package gov.nasa.jpl.issm;

import android.net.NetworkInfo;
import android.os.Bundle;
import android.app.ActionBar;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.webkit.WebView;
import android.widget.Button;

public class ISSMWebActivity extends Activity {

	// URL of the index page of the ISSM web application
	private String srcPath = "http://issm.jpl.nasa.gov/externalicelab/index.html";
	private String offPath = "file:///android_asset/externalicelab/index.html";
	private final String KEY = "mode";
	private int MODE;
	// private String srcPath =
	// "http://www.csupomona.edu/~tqnguyen/CIS311/Project3/index.html";
	private WebView myWebView;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_issmweb_online);
		getActionBar().setCustomView(R.layout.actionbar_top_web);
		getActionBar().setDisplayOptions(ActionBar.DISPLAY_SHOW_CUSTOM);
		MODE = getIntent().getExtras().getInt(KEY);

		Button webHome = (Button) findViewById(R.id.web_home);
		webHome.setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View v) {
				if (MODE == 0) {
					myWebView.loadUrl(srcPath);
				} else {
					myWebView.loadUrl(offPath);
				}
			}

		});

		Button webRefresh = (Button) findViewById(R.id.web_refresh);
		webRefresh.setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View v) {
				myWebView.loadUrl(myWebView.getOriginalUrl());
				// Log.i("srcUrl: ", srcPath);
				// Log.i("newUrl: ", myWebView.getOriginalUrl());
			}

		});

		// final ProgressDialog loading = new ProgressDialog(this);
		// loading.setMessage("Loading page...");
		// loading.setCancelable(false);
		// loading.show();

		myWebView = (WebView) findViewById(R.id.issmWeb);
		myWebView.setWebViewClient(new MyWebViewClient() {
			// @Override
			// public boolean shouldOverrideUrlLoading(WebView view, String url)
			// {
			// loading.show();
			// return false;
			// }
			//
			// @Override
			// public void onPageFinished(WebView view, String url) {
			// // hide loading
			// loading.dismiss();
			// }
		});
		myWebView.getSettings().setJavaScriptEnabled(true);
		myWebView.getSettings().setLoadWithOverviewMode(true);
		myWebView.getSettings().setUseWideViewPort(true);
		// myWebView.getSettings().setBuiltInZoomControls(true);
		if (MODE == 0) {
			myWebView.loadUrl(srcPath);
		} else {
			myWebView.loadUrl(offPath);
		}
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		getMenuInflater().inflate(R.menu.issmweb_online, menu);
		return true;
	}

	@Override
	public void onBackPressed() {
		if (MODE == 0) {
			if (myWebView.canGoBack()
					&& !myWebView.getOriginalUrl().equals(srcPath)) {
				myWebView.goBack();
			} else {
				showAlertBuilder();
			}
		} else {
			if (myWebView.canGoBack()
					&& !myWebView.getOriginalUrl().equals(offPath)) {
				myWebView.goBack();
			} else {
				showAlertBuilder();
			}
		}
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		switch (item.getItemId()) {
		case R.id.refresh:
			myWebView.loadUrl(myWebView.getOriginalUrl());
			break;
		default:
			break;
		}

		return true;
	}

	private void showAlertBuilder() {
		new AlertDialog.Builder(this)
				.setMessage("Are you sure you want to exit?")
				.setCancelable(false)
				.setPositiveButton("Yes",
						new DialogInterface.OnClickListener() {
							public void onClick(DialogInterface dialog, int id) {
								ISSMWebActivity.this.finish();
							}
						}).setNegativeButton("No", null).show();
	}

}
