package gov.nasa.jpl.issm;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;

/////////////////////////////////////////////////////////////
public class ColorBar extends View {
	Paint paint = new Paint();
	Paint textpaint = new Paint();
	// coordinate of the colorbar
	private int width = 30;
	private int start_x = 10;
	private int start_y = 10;
	// private int end_y = 0;
	boolean touch;
	final int MAX_SCALING = 255;
	double[][] colorBuffer;
	private String vmax;
	private String vmin;
	private String vmid;
	private boolean drawInformation = false;

	public ColorBar(Context context, AttributeSet attrs) {
		super(context, attrs);
		setWillNotDraw(false);
		paint.setStrokeWidth(5);
		textpaint.setColor(Color.WHITE);
		textpaint.setTextSize(20);
		touch = false;
	}

	// ----------------------------------------------------------------
	// change the color map
	public void setVelocity(double vmax, double vmin) {
		this.vmin = vmin + "";
		String max = vmax + "";
		String mid = ((vmax + vmin) / 2) + "";
		this.vmax = max.substring(0, 3)
				+ max.substring(max.length() - 3, max.length());
		this.vmid = mid.substring(0, 3)
				+ mid.substring(mid.length() - 3, mid.length());
		drawInformation = true;
	}

	// -----------------------------------------------------------------
	// change the color map
	public void setColorMap(ColorMap colorMap) {
		this.colorBuffer = colorMap.getColorBuffer();
	}

	// ----------------------------------------------------------------
	@Override
	public void onDraw(Canvas canvas) {
		int r, g, b;
		int y = start_y;
		for (int i = 63; i >= 0; i--) {
			r = Math.round((float) colorBuffer[i][0] * MAX_SCALING);
			g = Math.round((float) colorBuffer[i][1] * MAX_SCALING);
			b = Math.round((float) colorBuffer[i][2] * MAX_SCALING);
			paint.setColor(Color.argb(MAX_SCALING, r, g, b));
			canvas.drawLine(y, start_x, y, start_x + width, paint);

			if (drawInformation) {
				if (i == 63)
					canvas.drawText(vmin, y, start_x + width + 20, textpaint);
				if (i == 38)
					canvas.drawText(vmid, y, start_x + width + 20, textpaint);
				if (i == 8)
					canvas.drawText(vmax, y, start_x + width + 20, textpaint);
				if (i == 0)
					canvas.drawText("V(m/yr)", y + 10, start_x + width,
							textpaint);
			}
			y += 3;
		}
		// end_y = y;
	}
	// ----------------------------------------------------------------
	/*
	 * allow user to move color bar around
	 * 
	 * @Override public boolean onTouchEvent (MotionEvent event) {
	 * 
	 * if (event.getAction() == MotionEvent.ACTION_DOWN) { int x = (int)
	 * event.getX(); int y = (int) event.getY(); if(x >= start_x && x <=
	 * start_x+width && y >= start_y && y <= end_y) touch = true; } else if
	 * (event.getAction() == MotionEvent.ACTION_MOVE) { if(touch) { start_x =
	 * (int) event.getX(); start_y = (int) event.getY(); } invalidate();
	 * 
	 * } else if (event.getAction() == MotionEvent.ACTION_UP) { touch = false; }
	 * return true; }
	 */
	// ----------------------------------------------------------------
}

// //////////////////////////////////////////////////////////////////////////
class Velocity {
	private double vmax;
	private double vmin;

	public void setVmax(double vmax) {
		this.vmax = vmax;
	}

	public void setVmin(double vmin) {
		this.vmin = vmin;
	}

	public double getVmax() {
		return vmax;
	}

	public double getVmin() {
		return vmin;
	}
}