/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.youtube.player;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import com.google.android.youtube.player.internal.z;

public final class YouTubeIntents {
    private YouTubeIntents() {
    }

    public static boolean isYouTubeInstalled(Context context) {
        try {
            context.getPackageManager().getApplicationInfo(YouTubeIntents.a(context), 0);
            return true;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    public static String getInstalledYouTubeVersionName(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)YouTubeIntents.a((Context)context), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    public static int getInstalledYouTubeVersionCode(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)YouTubeIntents.a((Context)context), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return -1;
        }
    }

    public static boolean canResolvePlayVideoIntent(Context context) {
        Uri uri = Uri.parse((String)"http://www.youtube.com/watch?v=");
        return YouTubeIntents.a(context, uri);
    }

    public static Intent createPlayVideoIntent(Context context, String string) {
        return YouTubeIntents.createPlayVideoIntentWithOptions(context, string, false, false);
    }

    public final boolean canResolvePlayVideoIntentWithOptions(Context context) {
        int n2 = YouTubeIntents.getInstalledYouTubeVersionCode(context);
        return (z.a(context.getPackageManager()) ? n2 >= Integer.MAX_VALUE : n2 >= 3300) && YouTubeIntents.canResolvePlayVideoIntent(context);
    }

    public static Intent createPlayVideoIntentWithOptions(Context context, String string, boolean bl, boolean bl2) {
        string = Uri.parse((String)("http://www.youtube.com/watch?v=" + string));
        return YouTubeIntents.b(context, (Uri)string).putExtra("force_fullscreen", bl).putExtra("finish_on_ended", bl2);
    }

    public static boolean canResolveSearchIntent(Context context) {
        if (z.a(context.getPackageManager()) && YouTubeIntents.getInstalledYouTubeVersionCode(context) < Integer.MAX_VALUE) {
            return false;
        }
        Intent intent = new Intent("android.intent.action.SEARCH").setPackage(YouTubeIntents.a(context));
        return YouTubeIntents.a(context, intent);
    }

    public static Intent createSearchIntent(Context context, String string) {
        return new Intent("android.intent.action.SEARCH").setPackage(YouTubeIntents.a(context)).putExtra("query", string);
    }

    public static boolean canResolveOpenPlaylistIntent(Context context) {
        Uri uri = Uri.parse((String)"http://www.youtube.com/playlist?list=");
        return YouTubeIntents.a(context, uri);
    }

    public static Intent createOpenPlaylistIntent(Context context, String string) {
        string = YouTubeIntents.a(string);
        context = YouTubeIntents.b(context, (Uri)string);
        context.putExtra("authenticate", false);
        return context;
    }

    public static boolean canResolvePlayPlaylistIntent(Context context) {
        int n2 = YouTubeIntents.getInstalledYouTubeVersionCode(context);
        return (z.a(context.getPackageManager()) ? n2 >= Integer.MAX_VALUE : n2 >= 4000) && YouTubeIntents.canResolveOpenPlaylistIntent(context);
    }

    public static Intent createPlayPlaylistIntent(Context context, String string) {
        string = YouTubeIntents.a(string).buildUpon().appendQueryParameter("playnext", "1").build();
        context = YouTubeIntents.b(context, (Uri)string);
        context.putExtra("authenticate", false);
        return context;
    }

    public static boolean canResolveUserIntent(Context context) {
        Uri uri = Uri.parse((String)"http://www.youtube.com/user/");
        return YouTubeIntents.a(context, uri);
    }

    public static Intent createUserIntent(Context context, String string) {
        string = Uri.parse((String)("http://www.youtube.com/user/" + string));
        return YouTubeIntents.b(context, (Uri)string);
    }

    public static boolean canResolveUploadIntent(Context context) {
        Intent intent = new Intent("com.google.android.youtube.intent.action.UPLOAD").setPackage(YouTubeIntents.a(context)).setType("video/*");
        return YouTubeIntents.a(context, intent);
    }

    public static Intent createUploadIntent(Context context, Uri uri) throws IllegalArgumentException {
        if (uri == null) {
            throw new IllegalArgumentException("videoUri parameter cannot be null.");
        }
        if (!uri.toString().startsWith("content://media/")) {
            throw new IllegalArgumentException("videoUri parameter must be a URI pointing to a valid video file. It must begin with \"content://media/\"");
        }
        return new Intent("com.google.android.youtube.intent.action.UPLOAD").setPackage(YouTubeIntents.a(context)).setDataAndType(uri, "video/*");
    }

    private static boolean a(Context context, Uri uri) {
        uri = new Intent("android.intent.action.VIEW", uri).setPackage(YouTubeIntents.a(context));
        return YouTubeIntents.a(context, (Intent)uri);
    }

    private static Intent b(Context context, Uri uri) {
        return new Intent("android.intent.action.VIEW", uri).setPackage(YouTubeIntents.a(context));
    }

    private static boolean a(Context object, Intent intent) {
        return (object = object.getPackageManager().queryIntentActivities(intent, 65536)) != null && !object.isEmpty();
    }

    private static String a(Context context) {
        if (z.a(context.getPackageManager())) {
            return "com.google.android.youtube.googletv";
        }
        return "com.google.android.youtube";
    }

    private static Uri a(String string) {
        return Uri.parse((String)("http://www.youtube.com/playlist?list=" + string));
    }
}

