/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.youtube.player;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.util.Log;
import com.google.android.youtube.player.internal.ac;
import com.google.android.youtube.player.internal.m;
import com.google.android.youtube.player.internal.z;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum YouTubeInitializationResult {
    SUCCESS,
    INTERNAL_ERROR,
    UNKNOWN_ERROR,
    SERVICE_MISSING,
    SERVICE_VERSION_UPDATE_REQUIRED,
    SERVICE_DISABLED,
    SERVICE_INVALID,
    ERROR_CONNECTING_TO_SERVICE,
    CLIENT_LIBRARY_UPDATE_REQUIRED,
    NETWORK_ERROR,
    DEVELOPER_KEY_INVALID,
    INVALID_APPLICATION_SIGNATURE;


    public final boolean isUserRecoverableError() {
        switch (this) {
            case SERVICE_MISSING: 
            case SERVICE_DISABLED: 
            case SERVICE_VERSION_UPDATE_REQUIRED: {
                return true;
            }
        }
        return false;
    }

    public final Dialog getErrorDialog(Activity activity, int n2) {
        return this.getErrorDialog(activity, n2, null);
    }

    public final Dialog getErrorDialog(Activity object, int n2, DialogInterface.OnCancelListener object2) {
        Intent intent;
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)object);
        if (object2 != null) {
            builder.setOnCancelListener((DialogInterface.OnCancelListener)object2);
        }
        Activity activity = object;
        object2 = this;
        switch (1.a[((Enum)object2).ordinal()]) {
            case 1: 
            case 3: {
                intent = z.b(z.a((Context)activity));
                break;
            }
            case 2: {
                intent = z.a(z.a((Context)activity));
                break;
            }
            default: {
                intent = null;
            }
        }
        object2 = intent;
        a a2 = new a((Activity)object, (Intent)object2, n2);
        object = new m((Context)object);
        switch (this) {
            case SERVICE_MISSING: {
                return builder.setTitle((CharSequence)object.b).setMessage((CharSequence)object.c).setPositiveButton((CharSequence)object.d, (DialogInterface.OnClickListener)a2).create();
            }
            case SERVICE_DISABLED: {
                return builder.setTitle((CharSequence)object.e).setMessage((CharSequence)object.f).setPositiveButton((CharSequence)object.g, (DialogInterface.OnClickListener)a2).create();
            }
            case SERVICE_VERSION_UPDATE_REQUIRED: {
                return builder.setTitle((CharSequence)object.h).setMessage((CharSequence)object.i).setPositiveButton((CharSequence)object.j, (DialogInterface.OnClickListener)a2).create();
            }
        }
        throw new IllegalArgumentException("Unexpected errorReason: " + this.name());
    }

    private static final class a
    implements DialogInterface.OnClickListener {
        private final Activity a;
        private final Intent b;
        private final int c;

        public a(Activity activity, Intent intent, int n2) {
            this.a = ac.a(activity, (Object)"activity cannot be null");
            this.b = ac.a(intent, (Object)"intent cannot be null");
            this.c = ac.a(n2, (Object)"requestCode cannot be null");
        }

        public final void onClick(DialogInterface dialogInterface, int n2) {
            try {
                this.a.startActivityForResult(this.b, this.c);
                dialogInterface.dismiss();
                return;
            }
            catch (ActivityNotFoundException activityNotFoundException) {
                Object[] objectArray = new Object[]{activityNotFoundException};
                String string = "Can't perform resolution for YouTubeInitalizationError";
                Log.e((String)"YouTubeAndroidPlayerAPI", (String)String.format(string, objectArray));
                return;
            }
        }
    }
}

