function plot_unit(x,y,z,elements,data,isongrid,is2d,isquiver,options_structure)
%PLOT_UNIT - unit plot, display data
%
%   Usage:
%      plot_unit(x,y,z,elements,data,isongrid,is2d,isquiver,options_structure);
%
%   See also: PLOTMODEL, PLOT_MANAGER

%edgecolor?
if ~isnan(options_structure.edgecolor),
	edgecolor=options_structure.edgecolor;
else
	edgecolor='none';
end

%regular plot
if ~isquiver,

	%element data
	if ~isongrid
		pos=find(~isnan(data)); %needed fpr element on water
		if is2d,
			A=elements(pos,1); B=elements(pos,2); C=elements(pos,3); 
			patch( 'Faces', [A B C], 'Vertices', [x y z],'CData', data(pos),'FaceColor','flat','EdgeColor',edgecolor);
		else
			A=elements(pos,1); B=elements(pos,2); C=elements(pos,3); D=elements(pos,4); E=elements(pos,5); F=elements(pos,6);
			patch( 'Faces', [A B C], 'Vertices', [x y z],'CData', data(pos),'FaceColor','flat','EdgeColor',edgecolor);
			patch( 'Faces', [D E F], 'Vertices', [x y z],'CData', data(pos),'FaceColor','flat','EdgeColor',edgecolor);
			patch( 'Faces', [A B E D], 'Vertices', [x y z],'CData', data(pos),'FaceColor','flat','EdgeColor',edgecolor);
			patch( 'Faces', [B E F C ], 'Vertices', [x y z],'CData', data(pos),'FaceColor','flat','EdgeColor',edgecolor);
			patch( 'Faces', [C A D F ], 'Vertices', [x y z],'CData', data(pos),'FaceColor','flat','EdgeColor',edgecolor);
		end

	%grid data
	elseif isongrid
		if is2d,
			A=elements(:,1); B=elements(:,2); C=elements(:,3); 
			patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData', data(:),'FaceColor','interp','EdgeColor',edgecolor);
		else
			A=elements(:,1); B=elements(:,2); C=elements(:,3); D=elements(:,4); E=elements(:,5); F=elements(:,6);
			patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData', data(:),'FaceColor','interp','EdgeColor',edgecolor);
			patch( 'Faces', [D E F], 'Vertices', [x y z],'FaceVertexCData', data(:),'FaceColor','interp','EdgeColor',edgecolor);
			patch( 'Faces', [A B E D], 'Vertices', [x y z],'FaceVertexCData', data(:),'FaceColor','interp','EdgeColor',edgecolor);
			patch( 'Faces', [B E F C ], 'Vertices', [x y z],'FaceVertexCData', data(:),'FaceColor','interp','EdgeColor',edgecolor);
			patch( 'Faces', [C A D F ], 'Vertices', [x y z],'FaceVertexCData', data(:),'FaceColor','interp','EdgeColor',edgecolor);
		end
	end

%quiver
elseif isquiver,

	%grid data
	if isongrid,
		if is2d,
			quivercolor(x,y,data(:,1),data(:,2));
		else
			quivercolor3(x,y,z,data(:,1),data(:,2),data(:,3));
		end
	else
		error('plot_unit error message: element quiver not implemented yet')
	end
end
