function plot_gridnumbering(md,options_structure,width,i);
%PLOT_GRIDNUMBERING - plot grid numbering
%
%   Usage:
%      plot_gridnumbering(md,options_structure,width,i);
%
%   See also: PLOTMODEL

%process data and model
[x y z elements is2d]=processmesh(md,options_structure);
[gridnumbers isongrid isquiver]=processdata(md,[1:md.numberofgrids]',options_structure);

%plot
subplot(width,width,i); 

if is2d
	%plot mesh 
	A=elements(:,1); B=elements(:,2); C=elements(:,3);
	patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	for i=1:length(gridnumbers)
		text(x(i),y(i), z(i),num2str(gridnumbers(i)),'backgroundcolor',[0.8 0.9 0.8]);
	end
	if ~isnan(options_structure.highlight),
		for i=1:length(options_structure.highlight)
			text(x(options_structure.highlight(i)),y(options_structure.highlight(i)), z(options_structure.highlight(i)),num2str(options_structure.highlight(i)),'backgroundcolor',[1 0 0]);
		end
	end
else
	%plot mesh 
	A=elements(:,1); B=elements(:,2); C=elements(:,3); D=elements(:,4); E=elements(:,5); F=elements(:,6);
	patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	patch( 'Faces', [D E F], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	patch( 'Faces', [A B E D], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	patch( 'Faces', [B E F C ], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	patch( 'Faces', [C A D F ], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	for i=1:length(gridnumbers)
		text(x(i),y(i), z(i),num2str(i),'backgroundcolor',[0.8 0.9 0.8]);
	end
	if ~isnan(options_structure.highlight),
		for i=1:length(options_structure.highlight)
			text(x(options_structure.highlight(i)),y(options_structure.highlight(i)), z(options_structure.highlight(i)),num2str(options_structure.highlight(i)),'backgroundcolor',[1 0 0]);
		end
	end
end

%apply options
if isnan(options_structure.title)
	options_structure.title='Grid numbering';
end 
if isnan(options_structure.colorbar)
	options_structure.colorbar=0;
end
applyoptions(md,[],options_structure);
