function plot_quivervel(md,options_structure,width,i);
%PLOT_QUIVERVEL - plot arrow field of 2d velocities
%
%   Usage:
%      plot_quivervel(md,options_structure,width,i);
%
%   See also: PLOTMODEL

%process data and model
[x y z elements is2d]=processmesh(md,options_structure);
[vx isongrid isquiver]=processdata(md,md.vx,options_structure);
[vy isongrid isquiver]=processdata(md,md.vy,options_structure);

%plot mesh quivervel
subplot(width,width,i); 
					
%quiver 2d 
if ~isnan(options_structure.density)
	x=x(1:options_structure.density:end);
	y=y(1:options_structure.density:end);
	vx=vx(1:options_structure.density:end);
	vy=vy(1:options_structure.density:end);
end
quiver(x,y,vx,vy);

%apply options
if isnan(options_structure.title)
	options_structure.title='Velocity vectors';
end 
if isnan(options_structure.colorbar)
	options_structure.colorbar=0;
end
applyoptions(md,[],options_structure);
