function plot_basaldrag(md,options_structure,width,i,type);
%PLOT_BASALDRAG - plot basal drag
%
%   Usage:
%      plot_basaldrag(md,options_structure,width,i,type);
%
%   See also: PLOTMODEL

%check layer
if strcmpi(md.type,'3d')
	if options_structure.layer~=1,
		disp('plot_basaldrag warning: basal drag is displayed in the lower layer')
		options_structure.layer=1;
	end
end

%compute exponents
s=averaging(md,1./md.p,0);
r=averaging(md,md.p./md.q,0);

%compute horizontal velocity
if strcmpi(type,'basal_drag')
	ub=sqrt(md.vx.^2+md.vy.^2)/md.yts;
elseif strcmpi(type,'basal_dragx')
	ub=md.vx/md.yts;
elseif strcmpi(type,'basal_dragy')
	ub=md.vy/md.yts;
end

%compute basal drag
drag=(md.g*(md.rho_ice*md.thickness+md.rho_water*md.bed)).^r.*(md.drag).^2.*ub.^s/1000;

%Figure out if this is a Section plot
if ~isnan(options_structure.sectionvalue)
	plot_section(md,drag,options_structure,width,i);
	return;
else

	%process data and model
	[x y z elements is2d]=processmesh(md,options_structure);
	[basal_drag isongrid isquiver]=processdata(md,drag,options_structure);

	%plot basaldrag
	subplot(width,width,i); 
	plot_unit(x,y,z,elements,basal_drag,isongrid,is2d,isquiver,options_structure);

	%apply options
	if isnan(options_structure.title)
		options_structure.title='Basal drag [kPa]';
	end 
	if isnan(options_structure.view)
		options_structure.view=2;
	end
	applyoptions(md,basal_drag,options_structure);

end
