/*!\file Tetra.cpp
 * \brief: implementation of the Tetrament object
 */
/*Headers:*/
/*{{{*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include <stdio.h>
#include <string.h>
#include "../classes.h"
#include "../../shared/shared.h"
/*}}}*/

/*Element macros*/
#define NUMVERTICES 4

/*Constructors/destructor/copy*/
/*FUNCTION Tetra::Tetra(int id, int sid,int index, IoModel* iomodel,int nummodels){{{*/
Tetra::Tetra(int seg_id, int seg_sid, int index, IoModel* iomodel,int nummodels)
		:TetraRef(nummodels),ElementHook(nummodels,index+1,2,iomodel){

			/*id: */
			this->id  = seg_id;
			this->sid = seg_sid;

			//this->parameters: we still can't point to it, it may not even exist. Configure will handle this.
			this->parameters = NULL;

			/*intialize inputs: */
			this->inputs  = new Inputs();

			/*initialize pointers:*/
			this->nodes    = NULL;
			this->vertices = NULL;
			this->material = NULL;
			this->matpar   = NULL;
		}
/*}}}*/
/*FUNCTION Tetra::~Tetra(){{{*/
Tetra::~Tetra(){
	this->parameters=NULL;
}
/*}}}*/
/*FUNCTION Tetra::copy {{{*/
Object* Tetra::copy() {
	_error_("not implemented yet");
}
/*}}}*/

/*FUNCTION Tetra::Echo{{{*/
void Tetra::Echo(void){
	_printf_("Tetra:\n");
	_printf_("   id: " << id << "\n");
	if(nodes){
		nodes[0]->Echo();
		nodes[1]->Echo();
		nodes[2]->Echo();
		nodes[3]->Echo();
	}
	else _printf_("nodes = NULL\n");

	if (material) material->Echo();
	else _printf_("material = NULL\n");

	if (matpar) matpar->Echo();
	else _printf_("matpar = NULL\n");

	_printf_("   parameters\n");
	if (parameters) parameters->Echo();
	else _printf_("parameters = NULL\n");

	_printf_("   inputs\n");
	if (inputs) inputs->Echo();
	else _printf_("inputs=NULL\n");
}
/*}}}*/
/*FUNCTION Tetra::FiniteElement{{{*/
int Tetra::FiniteElement(void){
	return this->element_type;
}
/*}}}*/
/*FUNCTION Tetra::DeepEcho{{{*/
void Tetra::DeepEcho(void){

	_printf_("Tetra:\n");
	_printf_("   id: " << id << "\n");
	if(nodes){
		nodes[0]->DeepEcho();
		nodes[1]->DeepEcho();
		nodes[2]->DeepEcho();
		nodes[3]->DeepEcho();
	}
	else _printf_("nodes = NULL\n");

	if (material) material->DeepEcho();
	else _printf_("material = NULL\n");

	if (matpar) matpar->DeepEcho();
	else _printf_("matpar = NULL\n");

	_printf_("   parameters\n");
	if (parameters) parameters->DeepEcho();
	else _printf_("parameters = NULL\n");

	_printf_("   inputs\n");
	if (inputs) inputs->DeepEcho();
	else _printf_("inputs=NULL\n");

	return;
}
/*}}}*/
/*FUNCTION Tetra::ObjectEnum{{{*/
int Tetra::ObjectEnum(void){

	return TetraEnum;

}
/*}}}*/
/*FUNCTION Tetra::Id {{{*/
int Tetra::Id(){
	return id;
}
/*}}}*/

/*FUNCTION Tetra::GetNumberOfNodes;{{{*/
int Tetra::GetNumberOfNodes(void){
	return this->NumberofNodes();
}
/*}}}*/
/*FUNCTION Tetra::GetNumberOfVertices;{{{*/
int Tetra::GetNumberOfVertices(void){
	return NUMVERTICES;
}
/*}}}*/
/*FUNCTION Tetra::GetVerticesCoordinates(IssmDouble** pxyz_list)   THIS ONE{{{*/
void Tetra::GetVerticesCoordinates(IssmDouble** pxyz_list){

	IssmDouble* xyz_list = xNew<IssmDouble>(NUMVERTICES*3);
	::GetVerticesCoordinates(xyz_list,this->vertices,NUMVERTICES);

	/*Assign output pointer*/
	*pxyz_list = xyz_list;

}/*}}}*/
/*FUNCTION Tetra::IsIceInElement {{{*/
bool   Tetra::IsIceInElement(){

	_error_("not implemented yet");
}
/*}}}*/
bool Tetra::IsIcefront(void){/*{{{*/

	_error_("not implemented yet");
}/*}}}*/
/*FUNCTION Tetra::JacobianDeterminant{{{*/
void Tetra::JacobianDeterminant(IssmDouble* pJdet,IssmDouble* xyz_list,Gauss* gauss){

	_assert_(gauss->Enum()==GaussTetraEnum);
	this->GetJacobianDeterminant(pJdet,xyz_list,(GaussTetra*)gauss);

}
/*}}}*/
/*FUNCTION Tetra::JacobianDeterminantSurface{{{*/
void Tetra::JacobianDeterminantSurface(IssmDouble* pJdet,IssmDouble* xyz_list,Gauss* gauss){

	_error_("not implemented yet");

}
/*}}}*/
/*FUNCTION Tetra::NewGauss(){{{*/
Gauss* Tetra::NewGauss(void){
	return new GaussTetra();
}
/*}}}*/
/*FUNCTION Tetra::NewGauss(int order){{{*/
Gauss* Tetra::NewGauss(int order){
	return new GaussTetra(order);
}
/*}}}*/
/*FUNCTION Tetra::NewElementVector THIS ONE{{{*/
ElementVector* Tetra::NewElementVector(int approximation_enum){
	return new ElementVector(nodes,this->NumberofNodes(),this->parameters,approximation_enum);
}
/*}}}*/
/*FUNCTION Tetra::NewElementMatrix  THIS ONE{{{*/
ElementMatrix* Tetra::NewElementMatrix(int approximation_enum){
	return new ElementMatrix(nodes,this->NumberofNodes(),this->parameters,approximation_enum);
}
/*}}}*/
/*FUNCTION Tetra::NodalFunctions{{{*/
void Tetra::NodalFunctions(IssmDouble* basis, Gauss* gauss){

	_assert_(gauss->Enum()==GaussTetraEnum);
	this->GetNodalFunctions(basis,(GaussTetra*)gauss);

}
/*}}}*/
/*FUNCTION Tetra::NodalFunctionsDerivatives{{{*/
void Tetra::NodalFunctionsDerivatives(IssmDouble* dbasis,IssmDouble* xyz_list,Gauss* gauss){

	_assert_(gauss->Enum()==GaussTetraEnum);
	this->GetNodalFunctionsDerivatives(dbasis,xyz_list,(GaussTetra*)gauss);

}
/*}}}*/
/*FUNCTION Tetra::NormalSection{{{*/
void Tetra::NormalSection(IssmDouble* normal,IssmDouble* xyz_list_front){

	_error_("Not implemented yet");
}
/*}}}*/
