function h=quivercolor(x,y,u,v),
%QUIVERCOLOR - quiver plot with colors
%
%   to be perfected tomorrow
%
%   Usage:
%      h=quivercolor(x,y,u,v)
%
%   Example:
%      quivercolor(md.x,md.y,md.vx,md.vy);

%number of colors
numcolors=40;
%Set arrow size (1= full length of vector)
arrow=0.40;

%set the colormap 
c=colormap(jet(numcolors));
h=[];

%get norm Min and Max
Norm=sqrt(u.^2+v.^2);
Min=min(Norm);
Max=max(Norm);
Interval=(Max-Min)/numcolors;

%Get scaling factor
delta=((min(x)-max(x))^2+(min(y)-max(y))^2)/numel(x);
u=arrow*sqrt(delta)*u./Norm;
v=arrow*sqrt(delta)*v./Norm;

%loop over the number of colors
hold on
for i=1:numcolors
	pos=find( (Norm>=Min+(i-1)*Interval) & (Norm<=Min+i*Interval) );
	hprime=quiver(x(pos),y(pos),u(pos),v(pos),'Color',c(i,:),'ShowArrowHead','on','AutoScale','off');
	h=[h;hprime];
end
