/* 
 * \brief: damgage_core.cpp: core for the damage solution
 */ 

#include "./cores.h"
#include "../toolkits/toolkits.h"
#include "../classes/classes.h"
#include "../shared/shared.h"
#include "../modules/modules.h"
#include "../solutionsequences/solutionsequences.h"

void damage_core(FemModel* femmodel){

	/*intermediary*/
	bool   save_results;
	bool   dakota_analysis     = false;
	int    solution_type;
	int    numoutputs          = 0; 
	char   **requested_outputs = NULL;

	if(VerboseSolution()) _printf0_("   computing damage\n");
	
	//first recover parameters common to all solutions
	femmodel->parameters->FindParam(&save_results,SaveResultsEnum);
	femmodel->parameters->FindParam(&dakota_analysis,QmuIsdakotaEnum);
	femmodel->parameters->FindParam(&solution_type,SolutionTypeEnum);
	femmodel->parameters->FindParam(&numoutputs,DamageEvolutionNumRequestedOutputsEnum);
	if(numoutputs) femmodel->parameters->FindParam(&requested_outputs,&numoutputs,DamageEvolutionRequestedOutputsEnum);

	if(dakota_analysis && solution_type!=TransientSolutionEnum){
		femmodel->SetCurrentConfiguration(DamageEvolutionAnalysisEnum);
		ResetConstraintsx(femmodel);
	}

	femmodel->SetCurrentConfiguration(DamageEvolutionAnalysisEnum);
	solutionsequence_linear(femmodel);

	if(save_results){
		if(VerboseSolution()) _printf0_("   saving results\n");
		femmodel->RequestedOutputsx(&femmodel->results,requested_outputs,numoutputs);
	}
	
	/*Free resources:*/	
	if(numoutputs){
		for(int i=0;i<numoutputs;i++){
			xDelete<char>(requested_outputs[i]);
		} 
		xDelete<char*>(requested_outputs);
	}
}
