function grad_g=GradJCompute(m,inputs, u_g_obs);

%Recover solution for this stiffness and right hand side: 
if m.parameters.debug
	disp('      computing velocities...')
end
[u_g K_ff0 K_fs0 ]=diagnostic_core_nonlinear(m,inputs);

%Buid Du, difference between observed velocity and model velocity.
if m.parameters.debug
	disp('      computing Du...')
end
[Du_g]=Du(m.elements,m.nodes,m.loads,m.materials,m.parameters, u_g,u_g_obs,inputs);

%Reduce adjoint load from g-set to f-set
[Du_f] = Reduceloadfromgtof( Du_g, m.Gmn, K_fs0, m.ys0, m.nodesets);

%Solve for adjoint vector: 
if m.parameters.debug
	disp('      computing adjoint state...')
end
lambda_f=Solver(K_ff0,Du_f,[],m.parameters);

%Merge back to g set
lambda_g= Mergesolutionfromftog( lambda_f, m.Gmn, m.ys0, m.nodesets ); 

%Compute gradJ 
grad_g=Gradj(m.elements,m.nodes,m.loads,m.materials,m.parameters, u_g, lambda_g,inputs);
