/*!\file fx.cpp
 * \brief: analytical fonction for FS 
 * test case for a cube with Dirichlet conditions on all faces and no variation in z
 */

#include <math.h>
#include "../Numerics/types.h"
#include "../Numerics/constants.h"

IssmDouble fx2(IssmDouble x,IssmDouble y{   
	IssmDouble p = 2.0;  
	IssmDouble q = 2.0;   
	IssmDouble functionx;

	functionx =  -2*(y-1)*(y-1)*(x-1)*(2*x-1)*y-4*(y-1)*(y-1)*(x-1)*x*y-2*(y-1)*(y-1)*(2*x-1)*x*y +4*(y-1)*(2*y-1)*(x-1)*(x-1)*y+16*(y-1)*(2*y-1)*(x-1)*x*y+4*(y-1)*(2*y-1)*x*x*y +4*(y-1)*(x-1)*(x-1)*x*x-2*(y-1)*(x-1)*(2*x-1)*y*y-4*(y-1)*(x-1)*x*y*y -2*(y-1)*(2*x-1)*x*y*y+2*(2*y-1)*(x-1)*(x-1)*x*x+4*(x-1)*(x-1)*x*x*y+y-1/2; 
	return functionx;
}
IssmDouble fy2(IssmDouble x,IssmDouble y){   
	IssmDouble p = 2.0;  
	IssmDouble q = 2.0;   
	IssmDouble functiony;

	functiony = -4*(y-1)*(y-1)*(x-1)*(2*x-1)*x-4*(y-1)*(y-1)*(x-1)*y*y-2*(y-1)*(y-1)*(2*x-1)*y*y -4*(y-1)*(y-1)*x*y*y+2*(y-1)*(2*y-1)*(x-1)*(x-1)*x+2*(y-1)*(2*y-1)*(x-1)*x*x +4*(y-1)*(x-1)*(x-1)*x*y-16*(y-1)*(x-1)*(2*x-1)*x*y+4*(y-1)*(x-1)*x*x*y +2*(2*y-1)*(x-1)*(x-1)*x*y+2*(2*y-1)*(x-1)*x*x*y -4*(x-1)*(2*x-1)*x*y*y+x-1/2;

	return functiony;
}
