/*!\file fx.cpp
 * \brief: analytical fonction for FS 
 * test case for a cube with Dirichlet conditions on all faces and no variation in z
 */

#include <math.h>
#include "../Numerics/types.h"
#include "../Numerics/constants.h"

IssmDouble fx2(IssmDouble x,IssmDouble y{   
	IssmDouble p = 2.0;  
	IssmDouble q = 2.0;   
	IssmDouble functionx;

	functionx =  -2*(z-1)*(z-1)*(x-1)*(2*x-1)*z-4*(z-1)*(z-1)*(x-1)*x*z-2*(z-1)*(z-1)*(2*x-1)*x*z +4*(z-1)*(2*z-1)*(x-1)*(x-1)*z+16*(z-1)*(2*z-1)*(x-1)*x*z+4*(z-1)*(2*z-1)*x*x*z +4*(z-1)*(x-1)*(x-1)*x*x-2*(z-1)*(x-1)*(2*x-1)*z*z-4*(z-1)*(x-1)*x*z*z -2*(z-1)*(2*x-1)*x*z*z+2*(2*z-1)*(x-1)*(x-1)*x*x+4*(x-1)*(x-1)*x*x*z+z-1/2;

	return functionx;
}
IssmDouble fy2(IssmDouble x,IssmDouble y){   
	IssmDouble p = 2.0;  
	IssmDouble q = 2.0;   
	IssmDouble functiony;

	functiony = -4*(z-1)*(z-1)*(x-1)*(2*x-1)*x-4*(z-1)*(z-1)*(x-1)*z*z-2*(z-1)*(z-1)*(2*x-1)*z*z -4*(z-1)*(z-1)*x*z*z+2*(z-1)*(2*z-1)*(x-1)*(x-1)*x+2*(z-1)*(2*z-1)*(x-1)*x*x +4*(z-1)*(x-1)*(x-1)*x*z-16*(z-1)*(x-1)*(2*x-1)*x*z+4*(z-1)*(x-1)*x*x*z +2*(2*z-1)*(x-1)*(x-1)*x*z+2*(2*z-1)*(x-1)*x*x*z -4*(x-1)*(2*x-1)*x*z*z+x-1/2;

	return functiony;
}
