from model import *
from triangle import *
from setmask import *
from parameterize import *
from setflowequation import *
from EnumDefinitions import *
from solve import *
from MatlabFuncs import *

md=triangle(model(),'../Exp/Square.exp',100000.)
md=setmask(md,'','')
md=parameterize(md,'../Par/SquareSheetConstrained.py') 
md=setflowequation(md,'SSA','all')
md.cluster=generic('name',oshostname(),'np',1)
# md.cluster=generic('name',oshostname(),'np',3)

# parameters
md.transient.isstressbalance=True
md.transient.ismasstransport=False
md.transient.isthermal=False
md.transient.isgroundingline=False
md.transient.isgia=False
md.transient.islevelset=True

# init levelset function
xmin, xmax=min(md.mesh.x), max(md.mesh.x)
ymin, ymax=min(md.mesh.y), max(md.mesh.y)
xmed, ymed=(xmax+xmin)/2.,(ymax+ymin)/2.  

# distx=numpy.absolute(md.mesh.x.reshape(-1,1)-xmed)
# disty=numpy.absolute(md.mesh.y.reshape(-1,1)-ymed)
# md.mask.ice_levelset=numpy.maximum(distx,disty)-0.2*(xmax-xmin)

D=numpy.sqrt(numpy.power(md.mesh.x.reshape(-1,1)-xmed,2.)+numpy.power(md.mesh.y.reshape(-1,1)-ymed,2.))
R=0.2*(xmax-xmin)
md.mask.ice_levelset=D-R

md=solve(md,TransientSolutionEnum())

#Fields and tolerances to track changes
field_names     =['Vx','Vy','Vel','Pressure','MaskIceLevelset']
field_tolerances=[1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13]
field_values=[\
	md.results.TransientSolution[0].Vx,\
	md.results.TransientSolution[0].Vy,\
	md.results.TransientSolution[0].Vel,\
	md.results.TransientSolution[0].Pressure,\
	md.results.TransientSolution[0].MaskIceLevelset,\
	md.results.TransientSolution[1].Vx,\
	md.results.TransientSolution[1].Vy,\
	md.results.TransientSolution[1].Vel,\
	md.results.TransientSolution[1].Pressure,\
	md.results.TransientSolution[1].MaskIceLevelset,\
	]
