/*!\file GetMaskOfIceVerticesLSMx 
 * \brief: Return a mask for all the vertices determining whether the node should be active or not. 
 */

#include "./SetActiveNodesLSMx.h"

#include "../../classes/classes.h"
#include "../../shared/shared.h"
#include "../../toolkits/toolkits.h"
#include "../modules.h"

void SetActiveNodesLSMx(Elements* elements){/*{{{*/

	for(int i=0;i<elements->Size();i++){
		Element    *element  = dynamic_cast<Element*>(elements->GetObjectByOffset(i));
		int         numnodes = element->GetNumberOfNodes();
		IssmDouble *mask     = xNew<IssmDouble>(numnodes);
		element->GetInputListOnNodes(&mask[0],IceMaskNodeActivationEnum);
		
		for(int in=0;in<numnodes;in++){
			Node* node=element->GetNode(in);
			if(mask[in]==1.){
				node->Activate();
			}
			else {
				node->Deactivate();
			}
		}

		xDelete<IssmDouble>(mask);
	}
}/*}}}*/
void GetMaskOfIceVerticesLSMx(FemModel* femmodel){/*{{{*/

	/*Initialize vector with number of vertices*/
	int numvertices=femmodel->vertices->NumberOfVertices();
	Vector<IssmDouble>* vec_mask_ice=new Vector<IssmDouble>(numvertices); //vertices that have ice at next time step

	/*Fill vector with values: */
	for(int i=0;i<femmodel->elements->Size();i++){
		Element* element=dynamic_cast<Element*>(femmodel->elements->GetObjectByOffset(i));
		SetMaskOfIceElement(vec_mask_ice, element);
	}

	/*Assemble vector and serialize */
	vec_mask_ice->Assemble();
	IssmDouble* mask_ice=vec_mask_ice->ToMPISerial();
	InputUpdateFromVectorx(femmodel,mask_ice,IceMaskNodeActivationEnum,VertexSIdEnum);

	/*Clean up and return*/
	delete vec_mask_ice;
	delete mask_ice;

}/*}}}*/
void SetMaskOfIceElement(Vector<IssmDouble>* vec_mask_ice, Element* element){/*{{{*/

	/* Intermediaries */
	int numvertices = element->GetNumberOfVertices();
	
	if(element->IsIceInElement()){
		for(int i = 0;i<numvertices;i++){
			vec_mask_ice->SetValue(element->vertices[i]->Sid(),1.,INS_VAL);
		}
	}
}/*}}}*/
