/*
 * \file EnumDefinitions.h:
 * \brief: enum functions for our objects
 */

#ifndef _ENUM_DEFINITIONS_
#define _ENUM_DEFINITIONS_

enum definitions{
	/*Model fields {{{*/
	AutodiffIsautodiffEnum, 
	AutodiffNumDependentsEnum,
	AutodiffNumDependentObjectsEnum,
	AutodiffDependentObjectNamesEnum,
	AutodiffDependentObjectTypesEnum,
	AutodiffDependentObjectIndicesEnum,
	AutodiffDependentObjectsEnum,
	AutodiffNumIndependentsEnum,
	AutodiffNumIndependentObjectsEnum,
	AutodiffIndependentObjectNamesEnum,
	AutodiffIndependentObjectTypesEnum,
	AutodiffIndependentObjectsEnum,
	AutodiffJacobianEnum,
	AutodiffXpEnum,
	AutodiffDriverEnum,
	AutodiffFosForwardIndexEnum,
	AutodiffFovForwardIndicesEnum,
	AutodiffFosReverseIndexEnum,
	AutodiffMassFluxSegmentsPresentEnum,
	AutodiffKeepEnum,
	AutodiffObufsizeEnum,
	AutodiffLbufsizeEnum,
	AutodiffCbufsizeEnum,
	AutodiffTbufsizeEnum,
	AutodiffGcTriggerRatioEnum,
	AutodiffGcTriggerMaxSizeEnum,
	BalancethicknessSpcthicknessEnum,
	BalancethicknessStabilizationEnum,
	BalancethicknessThickeningRateEnum,
	BasalforcingsGeothermalfluxEnum,
	BasalforcingsMeltingRateCorrectionEnum,
	BasalforcingsMeltingRateEnum,
	BathymetryEnum,
	BedEnum,
	ConstantsGEnum,
	ConstantsReferencetemperatureEnum,
	ConstantsYtsEnum,
	DependentObjectEnum,
	StressbalanceAbstolEnum,
	StressbalanceIsnewtonEnum,
	StressbalanceMaxiterEnum,
	StressbalancePenaltyFactorEnum,
	StressbalanceReferentialEnum,
	StressbalanceReltolEnum,
	StressbalanceNumRequestedOutputsEnum,
	StressbalanceRequestedOutputsEnum,
	StressbalanceRestolEnum,
	StressbalanceRiftPenaltyLockEnum,
	StressbalanceRiftPenaltyThresholdEnum,
	StressbalanceShelfDampeningEnum,
	StressbalanceSpcvxEnum,
	StressbalanceSpcvyEnum,
	StressbalanceSpcvzEnum,
	StressbalanceFSreconditioningEnum,
	StressbalanceVertexPairingEnum,
	StressbalanceViscosityOvershootEnum,
	LoadingforceXEnum,
	LoadingforceYEnum,
	LoadingforceZEnum,
	FlowequationBorderSSAEnum,
	FlowequationBorderHOEnum,
	FlowequationBorderFSEnum,
	FlowequationElementEquationEnum,
	FlowequationIsSIAEnum,
	FlowequationIsSSAEnum,
	FlowequationIsL1L2Enum,
	FlowequationIsHOEnum,
	FlowequationIsFSEnum,
	FlowequationFeSSAEnum,
	FlowequationFeHOEnum,
	FlowequationFeFSEnum,
	FlowequationVertexEquationEnum,
	FrictionCoefficientEnum,
	FrictionPEnum,
	FrictionQEnum,
	GeometryHydrostaticRatioEnum,
	HydrologyModelEnum,
	HydrologyshreveEnum,
	HydrologyshreveCREnum,
	HydrologyshreveKnEnum,
	HydrologyshreveNEnum,
	HydrologyshrevePEnum,
	HydrologyshreveQEnum,
	HydrologyshreveSpcwatercolumnEnum,
	HydrologyshreveStabilizationEnum,
	HydrologydcEnum,
	SedimentHeadEnum,
	SedimentHeadOldEnum,
	SedimentHeadResidualEnum,
	EplHeadEnum,
	EplHeadOldEnum,
  EplHeadSlopeXEnum,
	EplHeadSlopeYEnum,
	HydrologydcMaxIterEnum,
	HydrologydcRelTolEnum,
	HydrologydcSpcsedimentHeadEnum,
	HydrologydcSedimentCompressibilityEnum,
	HydrologydcSedimentPorosityEnum,
	HydrologydcSedimentThicknessEnum,
	HydrologydcSedimentTransmitivityEnum,
	HydrologydcWaterCompressibilityEnum,
	HydrologydcSpceplHeadEnum,
	HydrologydcMaskEplactiveNodeEnum,
	HydrologydcMaskEplactiveEltEnum,
	HydrologydcEplCompressibilityEnum,
	HydrologydcEplPorosityEnum,
	HydrologydcEplInitialThicknessEnum,
	HydrologydcEplThicknessEnum,
	HydrologydcEplThicknessOldEnum,
	HydrologydcEplConductivityEnum,
	HydrologydcIsefficientlayerEnum,
	HydrologydcSedimentlimitFlagEnum,
	HydrologydcSedimentlimitEnum,
	HydrologydcTransferFlagEnum,
	HydrologydcLeakageFactorEnum,
	HydrologydcPenaltyFactorEnum,
	HydrologydcPenaltyLockEnum,
	HydrologyLayerEnum,
	HydrologySedimentEnum,
	HydrologyEfficientEnum,
	HydrologySedimentKmaxEnum,
	WaterTransferEnum,
	IndependentObjectEnum,
	InversionControlParametersEnum,
	InversionCostFunctionThresholdEnum,
	InversionCostFunctionsCoefficientsEnum,
	InversionCostFunctionsEnum,
	InversionGradientScalingEnum,
	InversionIscontrolEnum,
	InversionTaoEnum,
	InversionIncompleteAdjointEnum,
	InversionMaxParametersEnum,
	InversionMaxiterPerStepEnum,
	InversionMinParametersEnum,
	InversionNstepsEnum,
	InversionNumControlParametersEnum,
	InversionNumCostFunctionsEnum,
	InversionStepThresholdEnum,
	InversionThicknessObsEnum,
	InversionVxObsEnum,
	InversionVyObsEnum,
	InversionVzObsEnum,
	MaskIceLevelsetEnum,
	QmuMaskIceLevelsetEnum,
	MaterialsBetaEnum,
	MaterialsHeatcapacityEnum,
	MaterialsLatentheatEnum,
	MaterialsMeltingpointEnum,
	MaterialsMixedLayerCapacityEnum,
	MaterialsRheologyBEnum,
	MaterialsRheologyBbarEnum,
	MaterialsRheologyLawEnum,
	MaterialsRheologyNEnum,
	DamageDEnum,
	DamageFEnum,
	QmuDamageDEnum,
	DamageDbarEnum,
	DamageLawEnum,
	DamageC1Enum,
	DamageC2Enum,
	DamageC3Enum,
	DamageC4Enum,
	DamageHealingEnum,
	DamageStressThresholdEnum,
	DamageStabilizationEnum,
	DamagePenaltyThresholdEnum,
	DamagePenaltyLockEnum,
	DamagePenaltyFactorEnum,
	DamageMaxiterEnum,
	DamageSpcdamageEnum,
	DamageMaxDamageEnum,
	MaterialsRhoIceEnum,
	MaterialsRhoWaterEnum,
	MaterialsRhoFreshwaterEnum,
	MaterialsMuWaterEnum,
	MaterialsThermalExchangeVelocityEnum,
	MaterialsThermalconductivityEnum,
	MaterialsTemperateiceconductivityEnum,
	MaterialsLithosphereShearModulusEnum,
	MaterialsLithosphereDensityEnum,
	MaterialsMantleShearModulusEnum,
	MaterialsMantleDensityEnum,
	MeshAverageVertexConnectivityEnum,
	MeshElementonbedEnum,
	MeshElementonsurfaceEnum,
	MeshElements2dEnum,
	MeshElementsEnum,
	MeshLowerelementsEnum,
	MeshNumberofelements2dEnum,
	MeshNumberofelementsEnum,
	MeshNumberoflayersEnum,
	MeshNumberofvertices2dEnum,
	MeshNumberofverticesEnum,
	MeshUpperelementsEnum,
	MeshVertexonbedEnum,
	MeshVertexonsurfaceEnum,
	MeshXEnum,
	MeshYEnum,
	MeshZEnum,
	MeshTypeEnum,
	Mesh2DhorizontalEnum,
	Mesh2DverticalEnum,
	Mesh3DEnum,
	MiscellaneousNameEnum, //FIXME: only used by qmu, should not be marshalled (already in queueing script)
	MasstransportHydrostaticAdjustmentEnum,
	MasstransportIsfreesurfaceEnum,
	MasstransportMinThicknessEnum,
	MasstransportPenaltyFactorEnum,
	MasstransportSpcthicknessEnum,
	MasstransportStabilizationEnum,
	MasstransportVertexPairingEnum,
	MasstransportNumRequestedOutputsEnum,
	MasstransportRequestedOutputsEnum,
	QmuIsdakotaEnum,
	MassFluxSegmentsEnum,
	MassFluxSegmentsPresentEnum,
	QmuMassFluxSegmentsPresentEnum,
	QmuNumberofpartitionsEnum,
	QmuNumberofresponsesEnum,
	QmuPartitionEnum,
	QmuResponsedescriptorsEnum,
	QmuVariabledescriptorsEnum,
	QmuMaterialsRheologyBEnum,
	RiftsNumriftsEnum,
	RiftsRiftstructEnum,
	SettingsResultsOnNodesEnum,
	SettingsIoGatherEnum,
	SettingsLowmemEnum,
	SettingsOutputFrequencyEnum,
	SettingsWaitonlockEnum,

	DebugProfilingEnum,
	ProfilingCurrentMemEnum,
	ProfilingCurrentFlopsEnum,
	ProfilingSolutionTimeEnum,
	MaxIterationConvergenceFlagEnum,
	SteadystateMaxiterEnum,
	SteadystateNumRequestedOutputsEnum,
	SteadystateReltolEnum,
	SteadystateRequestedOutputsEnum,
	SurfaceEnum,

	ThermalIsenthalpyEnum,
	ThermalIsdynamicbasalspcEnum,
	ThermalMaxiterEnum,
	ThermalPenaltyFactorEnum,
	ThermalPenaltyLockEnum,
	ThermalPenaltyThresholdEnum,
	ThermalSpctemperatureEnum,
	ThermalStabilizationEnum,
	ThermalNumRequestedOutputsEnum,
	ThermalRequestedOutputsEnum,
	GiaMantleViscosityEnum,
	GiaLithosphereThicknessEnum,
	ThicknessEnum,
	TimesteppingStartTimeEnum,
	TimesteppingFinalTimeEnum,
	TimesteppingCflCoefficientEnum,
	TimesteppingTimeAdaptEnum,
	TimesteppingTimeStepEnum,
	TransientIsstressbalanceEnum,
	TransientIsgroundinglineEnum,
	TransientIsmasstransportEnum,
	TransientIsthermalEnum,
	TransientIsgiaEnum,
	TransientIsdamageEnum,
	TransientNumRequestedOutputsEnum,
	TransientRequestedOutputsEnum,
	/*}}}*/
	/*Surfaceforcings{{{*/
	SurfaceforcingsEnum,
	SMBEnum,
	SurfaceforcingsMassBalanceEnum,
	SMBpddEnum,
	SurfaceforcingsDelta18oEnum,
	SurfaceforcingsDelta18oSurfaceEnum,
	SurfaceforcingsIsdelta18oEnum,
	SurfaceforcingsPrecipitationsPresentdayEnum,
	SurfaceforcingsTemperaturesPresentdayEnum,
	SurfaceforcingsTemperaturesLgmEnum,
	SurfaceforcingsPrecipitationEnum,
	SurfaceforcingsDesfacEnum,
	SurfaceforcingsS0pEnum,
	SMBgradientsEnum,
	SurfaceforcingsMonthlytemperaturesEnum,
	SurfaceforcingsHrefEnum,
	SurfaceforcingsSmbrefEnum,
	SurfaceforcingsBPosEnum,
	SurfaceforcingsBNegEnum,
	SMBhenningEnum,
	/*TO BE REMOVED*/
	SurfaceforcingsIspddEnum,
	SurfaceforcingsIssmbgradientsEnum,
	/*}}}*/
	/*Solutions and Analyses{{{ */
	SolutionTypeEnum,
	AnalysisTypeEnum,
	ConfigurationTypeEnum,
	AdjointBalancethicknessAnalysisEnum,
	AdjointHorizAnalysisEnum,
	AnalysisCounterEnum,
	DefaultAnalysisEnum,
	BalancethicknessAnalysisEnum,
	BalancethicknessSolutionEnum,
	BalancethicknessSoftAnalysisEnum,
	BalancethicknessSoftSolutionEnum,
	BalancevelocityAnalysisEnum,
	BalancevelocitySolutionEnum,
	L2ProjectionEPLAnalysisEnum,
	L2ProjectionBaseAnalysisEnum,
	BedSlopeSolutionEnum,
	DamageEvolutionSolutionEnum,
	DamageEvolutionAnalysisEnum,
	StressbalanceAnalysisEnum,
	StressbalanceSIAAnalysisEnum,
	StressbalanceSolutionEnum,
	StressbalanceVerticalAnalysisEnum,
	EnthalpyAnalysisEnum,
	FlaimAnalysisEnum,
	FlaimSolutionEnum,
	HydrologyShreveAnalysisEnum,
	HydrologyDCInefficientAnalysisEnum,
	HydrologyDCEfficientAnalysisEnum,
	HydrologySolutionEnum,
	MeltingAnalysisEnum,
	MasstransportAnalysisEnum,
	MasstransportSolutionEnum,
	FreeSurfaceBaseAnalysisEnum,
	FreeSurfaceTopAnalysisEnum,
	SurfaceNormalVelocityEnum,
	ExtrudeFromBaseAnalysisEnum,
	ExtrudeFromTopAnalysisEnum,
	SteadystateSolutionEnum,
	SurfaceSlopeSolutionEnum,
	SmoothedSurfaceSlopeXAnalysisEnum,
	SmoothedSurfaceSlopeYAnalysisEnum,
	ThermalAnalysisEnum,
	ThermalSolutionEnum,
	TransientSolutionEnum,
	GiaSolutionEnum,
	GiaAnalysisEnum,
	MeshdeformationSolutionEnum,
	MeshdeformationAnalysisEnum,
	LevelsetAnalysisEnum,
	ExtrapolationAnalysisEnum,
	/*}}}*/
	/*Approximations {{{*/
	ApproximationEnum,
	NoneApproximationEnum,
	SIAApproximationEnum,
	SSAApproximationEnum,
	SSAHOApproximationEnum,
	SSAFSApproximationEnum,
	L1L2ApproximationEnum,
	HOApproximationEnum,
	HOFSApproximationEnum,
	FSApproximationEnum,
	FSvelocityEnum,
	FSpressureEnum,
	/*}}}*/
	/*Datasets {{{*/
	ConstraintsEnum,
	LoadsEnum,
	MaterialsEnum,
	NodesEnum,
	ContoursEnum,
	ParametersEnum,
	VerticesEnum,
	ResultsEnum,
	/*}}}*/
	/*Objects {{{*/
	GenericParamEnum,
	AdolcParamEnum,
	BoolInputEnum,
	BoolParamEnum,
	ContourEnum,
	ControlInputEnum,
	DatasetInputEnum,
	DoubleInputEnum,
	DataSetParamEnum,
	DoubleMatArrayParamEnum,
	DoubleMatParamEnum,
	DoubleParamEnum,
	DoubleVecParamEnum,
	ElementEnum,
	ExternalResultEnum,
	FileParamEnum,
	InputEnum,
	IntInputEnum,
	InputToExtrudeEnum,
	InputToL2ProjectEnum,
	IntParamEnum,
	IntVecParamEnum,
	TransientParamEnum,
	MaticeEnum,
	MatparEnum,
	NodeEnum,
	NumericalfluxEnum,
	NumericalfluxTypeEnum,
	ParamEnum,
	PengridEnum,
	PenpairEnum,
	PentaEnum,
	PentaInputEnum,
	ProfilerEnum,
	MatrixParamEnum,
	NodeSIdEnum,
	VectorParamEnum,
	RiftfrontEnum,
	RiftfrontTypeEnum,
	SegmentEnum,
	SegmentRiftfrontEnum,
	SpcDynamicEnum,
	SpcStaticEnum,
	SpcTransientEnum,
	StringArrayParamEnum,
	StringParamEnum,
	SegEnum,
	SegInputEnum,
	TriaEnum,
	TriaInputEnum,
	VertexEnum,
	VertexPIdEnum,
	VertexSIdEnum,
	/*}}}*/
	/*Fill {{{*/
	AirEnum,
	IceEnum,
	MelangeEnum,
	WaterEnum,
	/*}}}*/
	/*Rift state {{{*/
	ClosedEnum,
	FreeEnum,
	OpenEnum,
	/*}}}*/
	/*Inputs {{{*/
	AdjointpEnum,
	AdjointxEnum,
	AdjointyEnum,
	AdjointzEnum,
	BalancethicknessMisfitEnum,
	BedSlopeXEnum,
	BedSlopeYEnum,
	BoundaryEnum,
	ConvergedEnum,
	FillEnum,
	FractionIncrementEnum,
	FrictionEnum,
	GroundinglineMeltingRateEnum,
	InternalEnum,
	MassFluxEnum,
	MeltingOffsetEnum,
	MisfitEnum,
	PressureEnum,
	PressurePicardEnum,
	QmuPressureEnum,
	QmuVxEnum,
	QmuVyEnum,
	QmuVzEnum,
	QmuThicknessEnum,
	QmuBedEnum,
	QmuSurfaceEnum,
	QmuMeltingEnum,
	QmuVxMeshEnum,
	QmuVyMeshEnum,
	QmuVzMeshEnum,
	AndroidFrictionCoefficientEnum,
	ResetPenaltiesEnum,
	SegmentOnIceShelfEnum,
	SurfaceAbsVelMisfitEnum,
	SurfaceAreaEnum,
	SurfaceAverageVelMisfitEnum,
	SurfaceLogVelMisfitEnum,
	SurfaceLogVxVyMisfitEnum,
	SurfaceRelVelMisfitEnum,
	SurfaceSlopeXEnum,
	SurfaceSlopeYEnum,
	TemperatureEnum,
	TemperaturePicardEnum,
	ThicknessAbsMisfitEnum,
	VelEnum,
	VelocityEnum,
	VxAverageEnum,
	VxEnum,
	VxPicardEnum,
	VyAverageEnum,
	VyEnum,
	VyPicardEnum,
	VzEnum,
	VzSSAEnum,
	VzHOEnum,
	VzPicardEnum,
	VzFSEnum,
	VxMeshEnum,
	VyMeshEnum,
	VzMeshEnum,
	EnthalpyEnum,
	EnthalpyPicardEnum,
	ThicknessAbsGradientEnum,
	ThicknessAlongGradientEnum,
	ThicknessAcrossGradientEnum,
	IntMatParamEnum,
	RheologyBbarAbsGradientEnum,
	DragCoefficientAbsGradientEnum,
	TransientInputEnum,
	WaterfractionEnum,
	WatercolumnEnum,
	BasalFrictionEnum,
	ViscousHeatingEnum,
	QmuTemperatureEnum,
	HydrologyWaterVxEnum,
	HydrologyWaterVyEnum,
	StressTensorEnum,
	StressTensorxxEnum,
	StressTensorxyEnum,
	StressTensorxzEnum,
	StressTensoryyEnum,
	StressTensoryzEnum,
	StressTensorzzEnum,
	GiaCrossSectionShapeEnum,
	GiadWdtEnum,
	GiaWEnum,
	/*}}}*/
	/*Element Interpolations{{{*/
	P0Enum,
	P1Enum,
	P1DGEnum,
	P1bubbleEnum,
	P1bubblecondensedEnum,
	P2Enum,
	P2xP1Enum,
	P1xP2Enum,
	P1xP3Enum,
	P2xP4Enum,
	P1P1Enum,
	P1P1GLSEnum,
	MINIEnum,
	MINIcondensedEnum,
	TaylorHoodEnum,
	OneLayerP4zEnum,
	/*}}}*/
	/*Results{{{*/
	SaveResultsEnum,
	BoolExternalResultEnum,
	DoubleExternalResultEnum,
	DoubleMatExternalResultEnum,
	IntExternalResultEnum,
	JEnum,
	StringExternalResultEnum,
	StepEnum,
	TimeEnum,
	WaterColumnOldEnum,
	/*}}}*/
	/*Output Definitions{{{*/
	OutputdefinitionEnum,
	OutputdefinitionListEnum,
	MassfluxatgateEnum,
	MassfluxatgateNameEnum,
	MassfluxatgateSegmentsEnum,
	MisfitNameEnum,
	MisfitModelEnumEnum,
	MisfitObservationEnum,
	MisfitObservationEnumEnum,
	MisfitTimeinterpolationEnum,
	MisfitWeightsEnum,
	MisfitWeightsEnumEnum,
	SurfaceObservationEnum,
	WeightsSurfaceObservationEnum,
	/*}}}*/
	/*Responses{{{*/
	MinVelEnum,
	MaxVelEnum,
	MinVxEnum,
	MaxVxEnum,
	MaxAbsVxEnum,
	MinVyEnum,
	MaxVyEnum,
	MaxAbsVyEnum,
	MinVzEnum,
	MaxVzEnum,
	MaxAbsVzEnum,
	IceVolumeEnum,
	IceVolumeAboveFloatationEnum,
	TotalSmbEnum,
	/*}}}*/
	/*Relaxation{{{*/
	AbsoluteEnum,
	IncrementalEnum,
	/*}}}*/
	/*Grounding Line{{{*/
	AgressiveMigrationEnum,
	NoneEnum,
	SoftMigrationEnum,
	SubelementMigrationEnum,
	SubelementMigration2Enum,
	MaskGroundediceLevelsetEnum,
	QmuMaskGroundediceLevelsetEnum,
	/*}}}*/
	/*Gauss{{{*/
	GaussSegEnum,
	GaussTriaEnum,
	GaussPentaEnum,
	/*}}}*/
	/*Solver{{{*/
	FSSolverEnum,
	/*}}}*/
	/*Parameters{{{*/
	AdjointEnum,
	ColinearEnum,
	ControlSteadyEnum,
	FsetEnum,
	Gradient1Enum,
	Gradient2Enum,
	Gradient3Enum,
	GradientEnum,
	GroundinglineMigrationEnum,
	GsetEnum,
	IndexEnum,
	IndexedEnum,
	IntersectEnum,
	NodalEnum,
	OldGradientEnum,
	OutputFilePointerEnum,
	OutputFileNameEnum,
	LockFileNameEnum,
	ToolkitsOptionsAnalysesEnum,
	ToolkitsOptionsStringsEnum,
	QmuErrNameEnum,
	QmuInNameEnum,
	QmuOutNameEnum,
	RegularEnum,
	ScaledEnum,
	SeparateEnum,
	SsetEnum,
	VerboseEnum,
	/*}}}*/
	/*Interpolation {{{*/
	TriangleInterpEnum,
	BilinearInterpEnum,
	NearestInterpEnum,
	/*}}}*/
	/*Coordinate Systems{{{*/
	XYEnum,
	XYZEnum,
	/*}}}*/
	/*Toolkits{{{*/
	DenseEnum,
	MpiDenseEnum,
	MpiSparseEnum,
	SeqEnum,
	MpiEnum,
	MumpsEnum,
	GslEnum,
	/*}}}*/
	/*Options{{{*/
	OptionEnum,
	GenericOptionEnum,
	OptionCellEnum,
	OptionStructEnum,
	/*}}}*/
	/*Rheology law (move too Material) {{{*/
	PatersonEnum,
	ArrheniusEnum,
	LliboutryDuvalEnum,
	/*}}}*/
	/*Levelset related enums (will be moved to appropriate place when finished){{{*/
	TransientIslevelsetEnum,
	ExtrapolationVariableEnum,
	IceMaskNodeActivationEnum,
	/*}}}*/
	MaximumNumberOfDefinitionsEnum
};

#endif
