from model import *
from triangle import *
from setmask import *
from parameterize import *
from setflowequation import *
from EnumDefinitions import *
from solve import *
from MatlabFuncs import *

md=triangle(model(),'../Exp/Square.exp',150000.)
md=setmask(md,'','')
md=parameterize(md,'../Par/SquareSheetConstrained.py') 
md=setflowequation(md,'SSA','all')
md.cluster=generic('name',oshostname(),'np',3)

# parameters
md.transient.isstressbalance=True
md.transient.ismasstransport=False
md.transient.isthermal=False
md.transient.isgroundingline=False
md.transient.isgia=False
md.transient.islevelset=True

# init levelset function
ymin=numpy.min(md.mesh.y)
ymax=numpy.max(md.mesh.y)
xmin=min(md.mesh.x)
xmax=max(md.mesh.x)
xmed=(xmax+xmin)/2
ymed=(ymax+ymin)/2
distx=numpy.absolute(md.mesh.x.reshape(-1,1)-xmed)
disty=numpy.absolute(md.mesh.y.reshape(-1,1)-ymed)
md.mask.ice_levelset=numpy.maximum(distx,disty)-1.e5

md=solve(md,TransientSolutionEnum())

#Fields and tolerances to track changes
field_names     =['Vx','Vy','Vel','Pressure','MaskIceLevelset']
field_tolerances=[1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13]
field_values=[\
	md.results.TransientSolution[0].Vx,\
	md.results.TransientSolution[0].Vy,\
	md.results.TransientSolution[0].Vel,\
	md.results.TransientSolution[0].Pressure,\
	md.results.TransientSolution[0].MaskIceLevelset,\
	md.results.TransientSolution[1].Vx,\
	md.results.TransientSolution[1].Vy,\
	md.results.TransientSolution[1].Vel,\
	md.results.TransientSolution[1].Pressure,\
	md.results.TransientSolution[1].MaskIceLevelset,\
	]
