md=triangle(model(),'../Exp/Square.exp',100000.);
md=setmask(md,'','');
md=parameterize(md,'../Par/SquareSheetConstrained.par');
md=setflowequation(md,'SSA','all');
md.cluster=generic('name',oshostname(),'np',1);
md.hydrology=(hydrologydc);
md.hydrology.isefficientlayer=1;
md.hydrology.sedimentlimit_flag=1;
md.hydrology.sedimentlimit=800.0;
md.initialization.sediment_head=0.0*ones(md.mesh.numberofvertices,1);
md.hydrology.spcsediment_head=NaN*ones(md.mesh.numberofvertices,1);
md.basalforcings.melting_rate = 2.0*ones(md.mesh.numberofvertices,1);
md.hydrology.sediment_transmitivity=3*ones(md.mesh.numberofvertices,1);

md.initialization.epl_head=0.0*ones(md.mesh.numberofvertices,1);
md.hydrology.spcepl_head=NaN*ones(md.mesh.numberofvertices,1);
md.hydrology.mask_eplactive_node=0*ones(md.mesh.numberofvertices,1);
md.basalforcings.melting_rate = 2.0*ones(md.mesh.numberofvertices,1);
md.hydrology.epl_conductivity=30;
md.hydrology.epl_initial_thickness=1;
md.timestepping.time_step=0.2;
md.timestepping.final_time=2.0;

%md.verbose.solution=1;

md=solve(md,HydrologySolutionEnum());

%store=md.constants.g*md.hydrology.sediment_porosity*md.materials.rho_freshwater*((md.hydrology.sediment_compressibility/md.hydrology.sediment_porosity)+md.hydrology.water_compressibility);
%sedstore=20.0*store;
%for i=1:10
%diff=(mean(md.results.HydrologySolution(i).EplHead)*store+ ...
%			mean(md.results.HydrologySolution(i).SedimentHead)*sedstore-0.4*i)
%end

%Fields and tolerances to track changes
field_names     ={'SedimentWaterHead1','EplWaterHead1','SedimentHeadResidual1',...
								 'SedimentWaterHead4','EplWaterHead4','SedimentHeadResidual4',...
								 'SedimentWaterHead5','EplWaterHead5','SedimentHeadResidual5',...
								 'SedimentWaterHead9','EplWaterHead9','SedimentHeadResidual9'};
field_tolerances={1e-13, 1e-13, 1e-13,...
								 1e-13, 1e-13, 1e-13,...
								 1e-13, 6e-13, 8e-12,...
								 1e-13, 9e-13, 1e-11};
field_values={md.results.HydrologySolution(1).SedimentHead, ...
							md.results.HydrologySolution(1).EplHead,...
							md.results.HydrologySolution(1).SedimentHeadResidual,...
							md.results.HydrologySolution(4).SedimentHead,...
							md.results.HydrologySolution(4).EplHead,...
							md.results.HydrologySolution(4).SedimentHeadResidual, ...
							md.results.HydrologySolution(5).SedimentHead,...
							md.results.HydrologySolution(5).EplHead,...
							md.results.HydrologySolution(5).SedimentHeadResidual, ...
							md.results.HydrologySolution(9).SedimentHead,...
							md.results.HydrologySolution(9).EplHead,...
							md.results.HydrologySolution(9).SedimentHeadResidual};
