md=triangle(model(),'../Exp/Square.exp',150000.);
md=setmask(md,'all','');
md=parameterize(md,'../Par/SquareShelfConstrained.par');
md=extrude(md,3,1.);
md=setflowequation(md,'FS','all');

%Free surface
md.masstransport.isfreesurface=1;
md.timestepping.time_step=0.00001;
md.timestepping.final_time=0.00005;

%Go solve
md.cluster=generic('name',oshostname(),'np',3);
md=solve(md,TransientSolutionEnum());

%Fields and tolerances to track changes
field_names     ={...
	'Vx1','Vy1','Vel1','Pressure1','Bed1','Surface1','Thickness1',...
	'Vx2','Vy2','Vel2','Pressure2','Bed2','Surface2','Thickness2',...
	'Vx3','Vy3','Vel3','Pressure3','Bed3','Surface3','Thickness3'};
field_tolerances={...
	1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,...
	1e-09,1e-09,1e-09,1e-09,1e-09,1e-09,1e-09,...
	1e-09,1e-09,1e-09,1e-09,1e-09,1e-09,1e-09};
field_values={...
	(md.results.TransientSolution(1).Vx),...
	(md.results.TransientSolution(1).Vy),...
	(md.results.TransientSolution(1).Vel),...
	(md.results.TransientSolution(1).Pressure),...
	(md.results.TransientSolution(1).Bed),...
	(md.results.TransientSolution(1).Surface),...
	(md.results.TransientSolution(1).Thickness),...
	(md.results.TransientSolution(2).Vx),...
	(md.results.TransientSolution(2).Vy),...
	(md.results.TransientSolution(2).Vel),...
	(md.results.TransientSolution(2).Pressure),...
	(md.results.TransientSolution(2).Bed),...
	(md.results.TransientSolution(2).Surface),...
	(md.results.TransientSolution(2).Thickness),...
	(md.results.TransientSolution(3).Vx),...
	(md.results.TransientSolution(3).Vy),...
	(md.results.TransientSolution(3).Vel),...
	(md.results.TransientSolution(3).Pressure),...
	(md.results.TransientSolution(3).Bed),...
	(md.results.TransientSolution(3).Surface),...
	(md.results.TransientSolution(3).Thickness),...
	};
