function md=presolve(md)
%PRESOLVE - pre-solve phase operations.
%
%   Usage:
%      md=presolve(md)

%first, deal with rifts.
if isempty(md.rifts) | isnans(md.rifts),
	md.numrifts=0;
else
	md.numrifts=numel(md.rifts);
end

numpairs=0;
for i=1:md.numrifts,
	numpairs=numpairs+size(md.rifts(i).penaltypairs,1);
end

md.riftinfo=zeros(numpairs,9); % 2 for grids + 2 for elements+ 2 for  normals + 1 for length + 1 for fill + 1 for friction.

count=1;
for i=1:md.numrifts,
	numpairsforthisrift=size(md.rifts(i).penaltypairs,1);
	md.riftinfo(count:count+numpairsforthisrift-1,1:7)=md.rifts(i).penaltypairs;
	md.riftinfo(count:count+numpairsforthisrift-1,8)=md.rifts(i).fill;
	md.riftinfo(count:count+numpairsforthisrift-1,9)=md.rifts(i).friction;
	count=count+numpairsforthisrift;
end
