#!/bin/bash
#Synchronize Matlab and C Enums
#Create a matlab file using the same Enum as in EnumDefinitions.cpp
#and move the file to src/m/enum

#Get the list of interesting lines of EnumDefinitions.cpp and introduce line number
echo "Synchronizong with Matlab's Enums..."
cat EnumDefinitions.cpp | grep "return" | grep "int" | awk '{ printf "line%so %s\n", NR, $0 }' | sed -e "s/(void){//"  > temp
cat <<END > AnalysisTypeAsEnum.m
function string=AnalysisTypeAsEnum(enum)
%ANALYSISASENUM - get analysis type from Enum
%
%   file generated by src/c/SynchronizeMatlabEnum
%   to be synchronized with the corresponding C Enum
%   located in src/c/EnumDefinitions
%
%   Usage:
%      string=AnalysisTypeAsEnum(enum)

%initialize output
string='not found';

END

#get number of lines in temp
NUMBEROFLINES=`wc -l temp | awk '{printf("%s",$1);}'`;

# go through the lines of temp
for i in `seq 1 1 $NUMBEROFLINES`; do

	#Get name and enum of the line i
	NAME=`cat temp |  awk '/line'$i'o/ {printf("%s\n",$3);}';`;
	ENUM=`cat temp |  awk '/line'$i'o/ {printf("%s\n",$5);}';`;
	echo writing file $NAME \($i/$NUMBEROFLINES\)

	#write corresponding Matlab file
	cat <<END > $(echo $NAME.m)
function macro=$(echo $NAME)()
%$(echo `echo $NAME | sed -e "s/[a-z]/\U&/g"`) - Enum of $(echo `echo $NAME | sed -e "s/Enum//"`)
%
%   file generated by src/c/EnumDefinitions/SynchronizeMatlabEnum
%
%   Usage:
%      macro=$NAME()

macro=$ENUM
END

	#update AnalysisTypeAsEnum
	if [ $(echo $NAME | grep AnalysisEnum) ]
	then
		cat <<END >> AnalysisTypeAsEnum.m

if enum==$NAME(),
	string='$(echo `echo $NAME | sed -e "s/AnalysisEnum//g" | awk {'print tolower($_)'}`)';
end
END
	fi

	#move file to m/enum
	mv $NAME.m $ISSM_DIR/src/m/enum

done

#end of AnalysisTypeAsEnum
cat <<END >> AnalysisTypeAsEnum.m

%check that an analysis type has been found for enum
if strcmp(string,'not found'),
	error(['AnalysisTypeAsEnum error message: enum ' num2str(enum) ' not supported!']);
end
END

#clean up
mv AnalysisTypeAsEnum.m $ISSM_DIR/src/m/enum/
rm temp
