from model import *
from triangle import *
from setmask import *
from parameterize import *
from setflowequation import *
from EnumDefinitions import *
from solve import *
from MatlabFuncs import *

md=triangle(model(),'../Exp/Square.exp',150000.)
md=setmask(md,'','')
md=parameterize(md,'../Par/SquareSheetLevelset.py') 
md=setflowequation(md,'SSA','all')
md.cluster=generic('name',oshostname(),'np',3)
md=solve(md,TransientSolutionEnum())

#Fields and tolerances to track changes
field_names     =['Vx','Vy','Vel','Pressure','MaskIceLevelset']
field_tolerances=[1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13]
field_values=[\
	md.results.TransientSolution[0].Vx,\
	md.results.TransientSolution[0].Vy,\
	md.results.TransientSolution[0].Vel,\
	md.results.TransientSolution[0].Pressure,\
	md.results.TransientSolution[0].MaskIceLevelset,\
	md.results.TransientSolution[1].Vx,\
	md.results.TransientSolution[1].Vy,\
	md.results.TransientSolution[1].Vel,\
	md.results.TransientSolution[1].Pressure,\
	md.results.TransientSolution[1].MaskIceLevelset,\
	]
