/*!\file fx.cpp
 * \brief: analytical fonction for FS 
 * test case for a cube with Dirichlet conditions on all faces
 */

#include <math.h>
#include "../Numerics/types.h"
#include "../Numerics/constants.h"

IssmDouble fx2(IssmDouble x,IssmDouble y,IssmDouble z){   
	IssmDouble p = 2.0;  
	IssmDouble q = 2.0;   
	IssmDouble functionx;

	functionx = 2.*(cos(PI*p*x) - 1)*PI*PI*p*p*sin(PI*p*y) + 3*PI*PI*p*p*sin(PI*p*y)*cos(PI*p*x) + PI*q*sin(PI*q*y)*cos(PI*q*x);

	return functionx;
}
IssmDouble fy2(IssmDouble x,IssmDouble y,IssmDouble z){   
	IssmDouble p = 2.0;  
	IssmDouble q = 2.0;   
	IssmDouble functiony;

	functiony = -(cos(PI*p*y) - 1)*PI*PI*p*p*sin(PI*p*x) + PI*q*sin(PI*q*x)*cos(PI*q*y);

	return functiony;
}
IssmDouble fz2(IssmDouble x,IssmDouble y,IssmDouble z){   
	IssmDouble p = 2.0;  
	IssmDouble q = 2.0;   
	IssmDouble functionz;

	functionz = 2*PI*PI*p*p*sin(PI*p*x)*sin(PI*p*y);

	return functionz;
}
