/*!\file fx.cpp
 * \brief: analytical fonction for FS 
 * test case for a cube with Dirichlet conditions on all faces
 */

#include <math.h>
#include "../Numerics/types.h"
#include "../Numerics/constants.h"

IssmDouble fx1(IssmDouble x,IssmDouble y,IssmDouble z){   
	IssmDouble p = 2.0;  
	IssmDouble q = 2.0;   
	IssmDouble functionx;

	functionx =  4. * PI*PI * p*p * (cos(p*PI*x)-1) * sin(p*PI*y) * sin(p*PI*z)+ 2. * PI*PI*p*p*  sin(p*PI*y)    * sin(p*PI*z) * cos(p*PI*x) + q * PI * cos(q*PI*x) * sin(q*PI*y) * sin(q*PI*z);

	return functionx;
}
IssmDouble fy1(IssmDouble x,IssmDouble y,IssmDouble z){   
	IssmDouble p = 2.0;  
	IssmDouble q = 2.0;   
	IssmDouble functiony;

	functiony = - 4. * PI*PI * p*p * (cos(p*PI*y)-1) * sin(p*PI*x) * sin(p*PI*z)-  2. * PI*PI * p*p *  sin(p*PI*x)    * cos(p*PI*y) * sin(p*PI*z)+ q * PI * sin(q*PI*x) * cos(q*PI*y) * sin(q*PI*z);

	return functiony;
}
IssmDouble fz1(IssmDouble x,IssmDouble y,IssmDouble z){   
	IssmDouble p = 2.0;  
	IssmDouble q = 2.0;   
	IssmDouble functionz;

	functionz = - 2. * PI*PI * p*p * (cos(p*PI*z)-1) * sin(p*PI*x) * sin(p*PI*y)-PI*PI * p*p *  sin(p*PI*x)    * sin(p*PI*y) * cos(p*PI*z)+ q * PI * sin(q*PI*x) * sin(q*PI*y) * cos(q*PI*z);

	return functionz;
}
