from fielddisplay import fielddisplay
from EnumDefinitions import *
from checkfield import *
from WriteData import *

class transient(object):
	"""
	TRANSIENT class definition

	   Usage:
	      transient=transient();
	"""

	def __init__(self): # {{{
		self.ismasstransport   = False
		self.isstressbalance   = False
		self.isthermal         = False
		self.isgroundingline   = False
		self.isgia             = False
		self.islevelset        = False
		self.requested_outputs = []

		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(self): # {{{
		string='   transient solution parameters:'
		string="%s\n%s"%(string,fielddisplay(self,'ismasstransport','indicates if a masstransport solution is used in the transient'))
		string="%s\n%s"%(string,fielddisplay(self,'isstressbalance','indicates if a stressbalance solution is used in the transient'))
		string="%s\n%s"%(string,fielddisplay(self,'isthermal','indicates if a thermal solution is used in the transient'))
		string="%s\n%s"%(string,fielddisplay(self,'isgroundingline','indicates if a groundingline migration is used in the transient'))
		string="%s\n%s"%(string,fielddisplay(self,'isgia','indicates if a postglacial rebound is used in the transient'))
		string="%s\n%s"%(string,fielddisplay(self,'islevelset','LEVELSET METHOD DESCRIPTION'))
		string="%s\n%s"%(string,fielddisplay(self,'requested_outputs','list of additional outputs requested'))
		return string
		#}}}
	def defaultoutputs(self,md): # {{{

		return ['SurfaceforcingsMassBalance']

	#}}}
	def setdefaultparameters(self): # {{{
		
		#full analysis: Stressbalance, Masstransport and Thermal but no groundingline migration for now
		self.ismasstransport = True
		self.isstressbalance = True
		self.isthermal       = True
		self.isgroundingline = False
		self.isgia           = False
		self.islevelset           = False

		#default output
		self.requested_outputs=['default']
		return self
	#}}}
	def checkconsistency(self,md,solution,analyses):    # {{{

		#Early return
		if not solution==TransientSolutionEnum():
			return md

		md = checkfield(md,'fieldname','transient.ismasstransport','numel',[1],'values',[0,1])
		md = checkfield(md,'fieldname','transient.isstressbalance','numel',[1],'values',[0,1])
		md = checkfield(md,'fieldname','transient.isthermal','numel',[1],'values',[0,1])
		md = checkfield(md,'fieldname','transient.isgroundingline','numel',[1],'values',[0,1])
		md = checkfield(md,'fieldname','transient.isgia','numel',[1],'values',[0,1])
		md = checkfield(md,'fieldname','transient.islevelset','numel',[1],'values',[0,1])
		md = checkfield(md,'fieldname','transient.requested_outputs','stringrow',1)

		return md
	# }}}
	def marshall(self,md,fid):    # {{{
		WriteData(fid,'object',self,'fieldname','ismasstransport','format','Boolean')
		WriteData(fid,'object',self,'fieldname','isstressbalance','format','Boolean')
		WriteData(fid,'object',self,'fieldname','isthermal','format','Boolean')
		WriteData(fid,'object',self,'fieldname','isgroundingline','format','Boolean')
		WriteData(fid,'object',self,'fieldname','isgia','format','Boolean')
		WriteData(fid,'object',self,'fieldname','islevelset','format','Boolean')

		#process requested outputs
		outputs = self.requested_outputs
		indices = [i for i, x in enumerate(outputs) if x == 'default']
		if len(indices) > 0:
			outputscopy=outputs[0:max(0,indices[0]-1)]+self.defaultoutputs(md)+outputs[indices[0]+1:]
			outputs    =outputscopy
		WriteData(fid,'data',outputs,'enum',TransientRequestedOutputsEnum(),'format','StringArray')
	# }}}
