from fielddisplay import fielddisplay
from EnumDefinitions import *
from checkfield import *
from project3d import *
from WriteData import *

class SMBgradients(object):
	"""
	SMBgradients Class definition

	   Usage:
	      SMBgradients=SMBgradients();
	"""

	def __init__(self): # {{{
		self.href    = float('NaN')
		self.smbref  = float('NaN')
		self.b_pos   = float('NaN')
		self.b_neg   = float('NaN')
		#}}}
	def __repr__(self): # {{{
		string="   surface forcings parameters:"

		string="%s\n%s"%(string,fielddisplay(self,'issmbgradients','is smb gradients method activated (0 or 1, default is 0)'))
		string="%s\n%s"%(string,fielddisplay(self,'href',' reference elevation from which deviation is used to calculate SMB adjustment in smb gradients method'))
		string="%s\n%s"%(string,fielddisplay(self,'smbref',' reference smb from which deviation is calculated in smb gradients method'))
		string="%s\n%s"%(string,fielddisplay(self,'b_pos',' slope of hs - smb regression line for accumulation regime required if smb gradients is activated'))
		string="%s\n%s"%(string,fielddisplay(self,'b_neg',' slope of hs - smb regression line for ablation regime required if smb gradients is activated'))

		return string
		#}}}
	def extrude(self,md): # {{{

		#Nothing for now
		return self
	#}}}
	def initialize(self,md): # {{{

		#Nothing for now

		return self
	#}}}
	def checkconsistency(self,md,solution,analyses):    # {{{

		if MasstransportAnalysisEnum() in analyses:
			md = checkfield(md,'fieldname','surfaceforcings.href','forcing',1,'NaN',1)
			md = checkfield(md,'fieldname','surfaceforcings.smbref','forcing',1,'NaN',1)
			md = checkfield(md,'fieldname','surfaceforcings.b_pos','forcing',1,'NaN',1)
			md = checkfield(md,'fieldname','surfaceforcings.b_neg','forcing',1,'NaN',1)

		return md
	# }}}
	def marshall(self,md,fid):    # {{{

		yts=365.0*24.0*3600.0

		WriteData(fid,'enum',SurfaceforcingsEnum(),'data',SMBgradientsEnum(),'format','Integer');
		WriteData(fid,'object',self,'class','surfaceforcings','fieldname','href','format','DoubleMat','mattype',1,'forcinglength',md.mesh.numberofvertices+1)
		WriteData(fid,'object',self,'class','surfaceforcings','fieldname','smbref','format','DoubleMat','mattype',1,'scale',1./yts,'forcinglength',md.mesh.numberofvertices+1)
		WriteData(fid,'object',self,'class','surfaceforcings','fieldname','b_pos','format','DoubleMat','mattype',1,'scale',1./yts,'forcinglength',md.mesh.numberofvertices+1)
		WriteData(fid,'object',self,'class','surfaceforcings','fieldname','b_neg','format','DoubleMat','mattype',1,'scale',1./yts,'forcinglength',md.mesh.numberofvertices+1)
	# }}}
