from fielddisplay import fielddisplay
from EnumDefinitions import *
from checkfield import *
from project3d import *
from WriteData import *

class SMB(object):
	"""
	SMB Class definition

	   Usage:
	      SMB=SMB();
	"""

	def __init__(self): # {{{
		self.mass_balance = float('NaN')
		#}}}
	def __repr__(self): # {{{
		string="   surface forcings parameters:"
		string="%s\n%s"%(string,fielddisplay(self,'mass_balance','surface mass balance [m/yr ice eq]'))
		return string
		#}}}
	def extrude(self,md): # {{{

		self.mass_balance=project3d(md,'vector',self.mass_balance,'type','node');
		return self
	#}}}
	def initialize(self,md): # {{{

		if numpy.all(numpy.isnan(self.mass_balance)):
			self.mass_balance=numpy.zeros((md.mesh.numberofvertices,1))
			print "      no SMB.mass_balance specified: values set as zero"

		return self
	#}}}
	def checkconsistency(self,md,solution,analyses):    # {{{

		if MasstransportAnalysisEnum() in analyses:
			md = checkfield(md,'fieldname','surfaceforcings.mass_balance','forcing',1,'NaN',1)

		if BalancethicknessAnalysisEnum() in analyses:
			md = checkfield(md,'fieldname','surfaceforcings.mass_balance','size',[md.mesh.numberofvertices],'NaN',1)

		return md
	# }}}
	def marshall(self,md,fid):    # {{{

		yts=365.0*24.0*3600.0

		WriteData(fid,'enum',SurfaceforcingsEnum(),'data',SMBEnum(),'format','Integer');
		WriteData(fid,'object',self,'class','surfaceforcings','fieldname','mass_balance','format','DoubleMat','mattype',1,'scale',1./yts,'forcinglength',md.mesh.numberofvertices+1)
	# }}}
