%SMBgradients Class definition
%
%   Usage:
%      SMBgradients=SMBgradients();

classdef SMBgradients
	properties (SetAccess=public) 
		href   = NaN;
		smbref = NaN;
		b_pos  = NaN;
		b_neg  = NaN;
	end
	methods
		function obj = SMBgradients(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function self = initialize(self,md) % {{{

			%Nothing done for now

		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%Nothing for now

		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{

			if ismember(MasstransportAnalysisEnum(),analyses),
				md = checkfield(md,'fieldname','surfaceforcings.href','forcing',1,'NaN',1);
				md = checkfield(md,'fieldname','surfaceforcings.smbref','forcing',1,'NaN',1);
				md = checkfield(md,'fieldname','surfaceforcings.b_pos','forcing',1,'NaN',1);
				md = checkfield(md,'fieldname','surfaceforcings.b_neg','forcing',1,'NaN',1);
			end
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   surface forcings parameters:'));

			disp(sprintf('\n   SMB gradients parameters:'));
			fielddisplay(obj,'href',' reference elevation from which deviation is used to calculate SMB adjustment in smb gradients method');
			fielddisplay(obj,'smbref',' reference smb from which deviation is calculated in smb gradients method');
			fielddisplay(obj,'b_pos',' slope of hs - smb regression line for accumulation regime required if smb gradients is activated');
			fielddisplay(obj,'b_neg',' slope of hs - smb regression line for ablation regime required if smb gradients is activated');

		end % }}}
		function marshall(obj,md,fid) % {{{

			yts=365.0*24.0*3600.0;

			WriteData(fid,'enum',SurfaceforcingsEnum(),'data',SMBgradientsEnum(),'format','Integer');
			WriteData(fid,'object',obj,'class','surfaceforcings','fieldname','href','format','DoubleMat','mattype',1,'forcinglength',md.mesh.numberofvertices+1);
			WriteData(fid,'object',obj,'class','surfaceforcings','fieldname','smbref','format','DoubleMat','mattype',1,'scale',1./yts,'forcinglength',md.mesh.numberofvertices+1);
			WriteData(fid,'object',obj,'class','surfaceforcings','fieldname','b_pos','format','DoubleMat','mattype',1,'scale',1./yts,'forcinglength',md.mesh.numberofvertices+1);
			WriteData(fid,'object',obj,'class','surfaceforcings','fieldname','b_neg','format','DoubleMat','mattype',1,'scale',1./yts,'forcinglength',md.mesh.numberofvertices+1);

		end % }}}
	end
end
