%GROUNDINGLINE class definition
%
%   Usage:
%      groundingline=groundingline();

classdef groundingline
	properties (SetAccess=public) 
		migration    = '';
		melting_rate = NaN;
	end
	methods
		function obj = groundingline(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

			%Type of migration
			obj.migration='None';

			%basal melting rate correction: 
			obj.melting_rate=0; 

		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{

			md = checkfield(md,'fieldname','groundingline.migration','values',{'None' 'AgressiveMigration' 'SoftMigration' 'SubelementMigration','SubelementMigration2'});

			if ~strcmp(obj.migration,'None'),
				if isnan(md.geometry.bathymetry),
					md = checkmessage(md,['requesting grounding line migration, but bathymetry is absent!']);
				end
				pos=find(md.mask.groundedice_levelset>0.);
				if any(abs(md.geometry.bed(pos)-md.geometry.bathymetry(pos))>10^-10),
					md = checkmessage(md,['bathymetry not equal to bed on grounded ice!']);
				end
				if any(md.geometry.bathymetry - md.geometry.bed > 10^-9),
					md = checkmessage(md,['bathymetry superior to bed on floating ice!']);
				end
			end

		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   grounding line migration parameters:'));
			fielddisplay(obj,'migration','type of grounding line migration: ''SoftMigration'',''AgressiveMigration'' or ''None''');
			fielddisplay(obj,'melting_rate','melting rate applied when previously grounded parts start floating [m/yr]');

		end % }}}
		function marshall(obj,md,fid) % {{{
			WriteData(fid,'data',StringToEnum(obj.migration),'enum',GroundinglineMigrationEnum(),'format','Integer');
			WriteData(fid,'object',obj,'fieldname','melting_rate','format','Double');
		end % }}}
	end
end
