/*!\file:  Analysis.h
 * \brief abstract class for Analysis objects
 */ 

#ifndef _ANALYSIS_H_
#define _ANALYSIS_H_

#include "../toolkits/objects/toolkitobjects.h"
class Parameters;
class IoModel;
class Elements;
class Nodes;
class Constraints;
class Loads;
class Element;
class ElementVector;
class ElementMatrix;
class Gauss;

class Analysis{

	public: 
		/*Constructor/Destructor*/
		virtual      ~Analysis(){};

		/*Model processing*/
		virtual int  DofsPerNode(int** doflist,int meshtype,int approximation)=0;
		virtual void UpdateParameters(Parameters* parameters,IoModel* iomodel,int solution_enum,int analysis_enum)=0;
		virtual void UpdateElements(Elements* elements,IoModel* iomodel,int analysis_counter,int analysis_type)=0;
		virtual void CreateNodes(Nodes* nodes,IoModel* iomodel)=0;
		virtual void CreateConstraints(Constraints* constraints,IoModel* iomodel)=0;
		virtual void CreateLoads(Loads* loads, IoModel* iomodel)=0;

		/*Finite element Analysis*/
		virtual ElementVector* CreateDVector(Element* element)=0;
		virtual ElementMatrix* CreateJacobianMatrix(Element* element)=0;
		virtual ElementMatrix* CreateKMatrix(Element* element)=0;
		virtual ElementVector* CreatePVector(Element* element)=0;
		virtual void GetSolutionFromInputs(Vector<IssmDouble>* solution,Element* element)=0;
		virtual void InputUpdateFromSolution(IssmDouble* solution,Element* element)=0;
};
#endif
