/*! \file EnthalpyAnalysis.h 
 *  \brief: header file for generic external result object
 */

#ifndef _EnthalpyAnalysis_
#define _EnthalpyAnalysis_

/*Headers*/
#include "./Analysis.h"

class EnthalpyAnalysis: public Analysis{

	public:
		/*Model processing*/
		int  DofsPerNode(int** doflist,int meshtype,int approximation);
		void UpdateParameters(Parameters* parameters,IoModel* iomodel,int solution_enum,int analysis_enum);
		void UpdateElements(Elements* elements,IoModel* iomodel,int analysis_counter,int analysis_type);
		void CreateNodes(Nodes* nodes,IoModel* iomodel);
		void CreateConstraints(Constraints* constraints,IoModel* iomodel);
		void CreateLoads(Loads* loads, IoModel* iomodel);

		/*Finite element Analysis*/
		ElementVector* CreateDVector(Element* element);
		ElementMatrix* CreateJacobianMatrix(Element* element);
		ElementMatrix* CreateKMatrix(Element* element);
		ElementMatrix* CreateKMatrixVolume(Element* element);
		ElementMatrix* CreateKMatrixShelf(Element* element);
		ElementVector* CreatePVector(Element* element);
		ElementVector* CreatePVectorVolume(Element* element);
		ElementVector* CreatePVectorSheet(Element* element);
		ElementVector* CreatePVectorShelf(Element* element);
		void GetBConduct(IssmDouble* B,Element* element,IssmDouble* xyz_list,Gauss* gauss);
		void GetBAdvec(IssmDouble* B,Element* element,IssmDouble* xyz_list,Gauss* gauss);
		void GetBAdvecprime(IssmDouble* B,Element* element,IssmDouble* xyz_list,Gauss* gauss);
		void GetSolutionFromInputs(Vector<IssmDouble>* solution,Element* element);
		void InputUpdateFromSolution(IssmDouble* solution,Element* element);

		/*Intermediaries*/
		IssmDouble EnthalpyDiffusionParameter(Element* element,IssmDouble enthalpy,IssmDouble pressure);
		IssmDouble EnthalpyDiffusionParameterVolume(Element* element,int enthalpy_enum);
		IssmDouble PureIceEnthalpy(Element* element,IssmDouble pressure);
		IssmDouble TMeltingPoint(Element* element,IssmDouble pressure);
};
#endif
