% This file can be run to update the velocity archives  of the test3.
% This test deals with an iceshelf with icefront for a 2d model. The geometry 
% is square. Just run this file in Matlab, with a properly setup Ice code. 

% The archive files will be saved in this directory but will not commited to ice1. 
% Just commit the result if you want to.

md=model;
md=mesh(md,'DomainOutline.exp',50000);
md=geography(md,'all','');
md=parameterize(md,'Square.par');
md=setelementstype(md,'macayeal','all');

%Compute solution with MacAyeal's model
md=solve(md,'diagnostic','macayeal');
archive_macayeal=md.vel;

%Save the solution in the directory
save archive_macayeal archive_macayeal

%Compute solution with Ice model
md.acceleration=0;
md=solve(md,'diagnostic','ice');
archive_ice=md.vel;

%Save the solution in the directory
save archive_ice archive_ice

%Compute solution with accelerated Ice model
md.acceleration=1;
md=solve(md,'diagnostic','ice');
archive_acc=md.vel;

%Save the solution in the directory
save archive_acc archive_acc

%Compute prognostic with Ice model
md=solve(md,'prognostic','ice');
archive_thickness=md.new_thickness;

%Save the new thickness in the directory
save archive_thickness archive_thickness


