%Test on the diagnostic model and the prognostic in 2d

%Evolution of the ice shelf
md=model;
md=mesh(md,'DomainOutline.exp',7100);
md=geography(md,'all','');
md=parameterize(md,'Square.par');
md=setelementstype(md,'macayeal','all'); %MacAyeal's model and 2d

%Compute solution for MacAyeal's model 
md=solve(md,'diagnostic','ice');

%Launch transient solution
md.ndt=5000*md.yts; %time of evolution
md.dt=500*md.yts; %time vetween two iterations
md=solve(md,'transient');

%plot results
plotmodel(md,'data',md.transient_results(end).vx,'data',md.transient_results(end).vy,'data',md.transient_results(end).thickness)
