/*!\file Element.cpp
 * \brief: implementation of the Element object
 */
/*Headers:*/
/*{{{*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif
#include <stdio.h>
#include <string.h>
#include "../classes.h"
#include "../../shared/shared.h"
/*}}}*/

/*Constructors/destructor/copy*/
Element::Element(){/*{{{*/
	this->inputs     = NULL;
	this->nodes      = NULL;
}/*}}}*/
Element::~Element(){/*{{{*/
	delete inputs;
}
/*}}}*/

/*Other*/
void Element::AddInput(Input* input_in){/*{{{*/

	/*Call inputs method*/
	_assert_(this->inputs);
	this->inputs->AddInput(input_in);
}/*}}}*/
bool Element::AllActive(void){/*{{{*/

	int numnodes = this->GetNumberOfNodes();
	for(int i=0;i<numnodes;i++){
		if(!this->nodes[i]->IsActive()) return false;
	}
	return true;
}/*}}}*/
bool Element::AnyActive(void){/*{{{*/

	int numnodes = this->GetNumberOfNodes();
	for(int i=0;i<numnodes;i++){
		if(this->nodes[i]->IsActive()) return true;
	}
	return false;
}/*}}}*/
Input* Element::GetInput(int inputenum){/*{{{*/
	return inputs->GetInput(inputenum);
}/*}}}*/
