/*!\file:  Element.h
 * \brief abstract class for Element object
 * This class is a place holder for the Tria and the Penta elements. 
 * It is derived from Element, so DataSets can contain them.
 */ 

#ifndef _ELEMENT_H_
#define _ELEMENT_H_

/*Headers:*/
/*{{{*/
#include "../../datastructures/datastructures.h"
#include "../../toolkits/toolkits.h"
#include "../Update.h"
class DataSet;
class Parameters;
class Elements;
class Loads;
class Node;
class Nodes;
class Vertices;
class Materials;
class Matpar;
class Input;
class Gauss;
class ElementVector;
template <class doublematrix> class Matrix;
template <class doubletype> class Vector;
class ElementMatrix;
class ElementVector;
/*}}}*/

class Element: public Object,public Update{

	public: 

		virtual        ~Element(){};

		virtual bool        AllActive(void)=0;
		virtual bool        AnyActive(void)=0;
		virtual IssmDouble CharacteristicLength(void)=0;
		virtual void   Configure(Elements* elements,Loads* loads,Nodes* nodes,Vertices* vertices,Materials* materials,Parameters* parameters)=0;
		virtual void   SetCurrentConfiguration(Elements* elements,Loads* loads,Nodes* nodes,Materials* materials,Parameters* parameters)=0;
		virtual void   SetwiseNodeConnectivity(int* d_nz,int* o_nz,Node* node,bool* flags,int* flagsindices,int set1_enum,int set2_enum)=0;
		virtual void   AddBasalInput(int input_enum, IssmDouble* values, int interpolation_enum)=0;
		virtual void   AddInput(int input_enum, IssmDouble* values, int interpolation_enum)=0;
		virtual void   AddInput(Input* input_in)=0;
		virtual void   AddMaterialInput(int input_enum, IssmDouble* values, int interpolation_enum)=0;
		virtual ElementMatrix* CreateKMatrix(void)=0;
		virtual void   CreateDVector(Vector<IssmDouble>* df)=0;
		virtual ElementVector* CreatePVector(void)=0;
		virtual void   CreateJacobianMatrix(Matrix<IssmDouble>* Jff)=0;
		virtual void   DeleteMaterials(void)=0;
		virtual void   ElementSizes(IssmDouble* phx,IssmDouble* phy,IssmDouble* phz)=0;
		virtual void   EnthalpyToThermal(IssmDouble* ptemperature,IssmDouble* pwaterfraction,IssmDouble enthalpy,IssmDouble pressure)=0;
		virtual IssmDouble EnthalpyDiffusionParameter(IssmDouble enthalpy,IssmDouble pressure)=0;
		virtual IssmDouble EnthalpyDiffusionParameterVolume(int numvertices,IssmDouble* enthalpy,IssmDouble* pressure)=0;
		virtual void   FindParam(bool* pvalue,int paramenum)=0;
		virtual void   FindParam(int* pvalue,int paramenum)=0;
		virtual void   FindParam(IssmDouble* pvalue,int paramenum)=0;
		virtual void   FindParam(int** pvalues,int* psize,int paramenum)=0;
		virtual int    FiniteElement(void)=0;
		virtual IssmDouble GetMaterialParameter(int enum_in)=0;
		virtual IssmDouble MinEdgeLength(IssmDouble* xyz_list)=0;
		virtual void   NodalFunctions(IssmDouble* basis,Gauss* gauss)=0;
		virtual void   NodalFunctionsVelocity(IssmDouble* basis, Gauss* gauss)=0;
		virtual void   NodalFunctionsPressure(IssmDouble* basis, Gauss* gauss)=0;
		virtual void   NodalFunctionsDerivatives(IssmDouble* dbasis,IssmDouble* xyz_list,Gauss* gauss)=0;
		virtual void   NodalFunctionsDerivativesVelocity(IssmDouble* dbasis,IssmDouble* xyz_list,Gauss* gauss)=0;
		virtual void   NormalSection(IssmDouble* normal,IssmDouble* xyz_list)=0;
		virtual void   NormalTop(IssmDouble* normal,IssmDouble* xyz_list)=0;
		virtual void   NormalBase(IssmDouble* normal,IssmDouble* xyz_list)=0;
		virtual IssmDouble PureIceEnthalpy(IssmDouble pressure)=0;
		virtual void   TransformLoadVectorCoord(ElementVector* pe,int transformenum)=0;
		virtual void   TransformLoadVectorCoord(ElementVector* pe,int* transformenum_list)=0;
		virtual void   TransformLoadVectorCoord(ElementVector* pe,int numnodes,int transformenum)=0;
		virtual void   TransformLoadVectorCoord(ElementVector* pe,int numnodes,int* transformenum_list)=0;
		virtual void   TransformSolutionCoord(IssmDouble* values,int transformenum)=0;
		virtual void   TransformSolutionCoord(IssmDouble* values,int* transformenum_list)=0;
		virtual void   TransformSolutionCoord(IssmDouble* values,int numnodes,int transformenum)=0;
		virtual void   TransformSolutionCoord(IssmDouble* values,int numnodes,int* transformenum_list)=0;
		virtual void   TransformStiffnessMatrixCoord(ElementMatrix* Ke,int transformenum)=0;
		virtual void   TransformStiffnessMatrixCoord(ElementMatrix* Ke,int* transformenum_list)=0;
		virtual void   TransformStiffnessMatrixCoord(ElementMatrix* Ke,int numnodes,int transformenum)=0;
		virtual void   TransformStiffnessMatrixCoord(ElementMatrix* Ke,int numnodes,int* transformenum_list)=0;
		virtual Element* GetBasalElement(void)=0;
		virtual void	GetDofList(int** pdoflist,int approximation_enum,int setenum)=0;
		virtual void	GetDofListVelocity(int** pdoflist,int setenum)=0;
		virtual void	GetDofListPressure(int** pdoflist,int setenum)=0;
		virtual void   JacobianDeterminant(IssmDouble*  Jdet, IssmDouble* xyz_list,Gauss* gauss)=0;
		virtual void   JacobianDeterminantLine(IssmDouble* Jdet, IssmDouble* xyz_list,Gauss* gauss)=0;
		virtual void   JacobianDeterminantSurface(IssmDouble* Jdet, IssmDouble* xyz_list,Gauss* gauss)=0;
		virtual void   JacobianDeterminantBase(IssmDouble* Jdet,IssmDouble* xyz_list_base,Gauss* gauss)=0;
		virtual void   JacobianDeterminantTop(IssmDouble* Jdet,IssmDouble* xyz_list_base,Gauss* gauss)=0;
		virtual void   GetSolutionFromInputsOneDof(Vector<IssmDouble>* solution,int solutionenum)=0;
		virtual int    GetNodeIndex(Node* node)=0;
		virtual int    GetNumberOfNodes(void)=0;
		virtual int    GetNumberOfNodesVelocity(void)=0;
		virtual int    GetNumberOfNodesPressure(void)=0;
		virtual int    GetNumberOfVertices(void)=0;
		virtual void   GetNodesSidList(int* sidlist)=0;
		virtual void   GetNodesLidList(int* sidlist)=0;

		virtual int    Sid()=0;
		virtual bool   IsFloating()=0; 
		virtual bool   IsNodeOnShelfFromFlags(IssmDouble* flags)=0; 
		virtual bool   IsOnBed()=0;
		virtual bool   IsOnSurface()=0;
		virtual void   GetGroundedPart(int* point1,IssmDouble* fraction1,IssmDouble* fraction2, bool* mainlyfloating)=0;
		virtual IssmDouble GetGroundedPortion(IssmDouble* xyz_list)=0;
		virtual void   GetInputListOnNodes(IssmDouble* pvalue,int enumtype)=0;
		virtual void   GetInputListOnNodes(IssmDouble* pvalue,int enumtype,IssmDouble defaultvalue)=0;
		virtual void   GetInputListOnVertices(IssmDouble* pvalue,int enumtype)=0;
		virtual void   GetInputListOnVertices(IssmDouble* pvalue,int enumtype,IssmDouble defaultvalue)=0;
		virtual Input* GetInput(int inputenum)=0;
		virtual Input* GetMaterialInput(int inputenum)=0;
		virtual void   GetInputValue(IssmDouble* pvalue,Node* node,int enumtype)=0;
		virtual void   GetInputValue(bool* pvalue,int enum_type)=0;
		virtual void   GetInputValue(int* pvalue,int enum_type)=0;
		virtual void   GetInputValue(IssmDouble* pvalue,int enum_type)=0;
		virtual void   GetInputValue(IssmDouble* pvalue,Gauss* gauss,int enum_type)=0;
		virtual void   GetVerticesCoordinates(IssmDouble** xyz_list)=0;
		virtual void   GetVerticesCoordinatesBase(IssmDouble** xyz_list)=0;
		virtual void   GetVerticesCoordinatesTop(IssmDouble** xyz_list)=0;
		virtual IssmDouble GetZcoord(Gauss* gauss)=0;
		virtual IssmDouble GetYcoord(Gauss* gauss)=0;
		virtual void   GetMaterialInputValue(IssmDouble* pvalue,Node* node,int enumtype)=0;

		virtual IssmDouble SurfaceArea(void)=0;
		virtual void   InputDepthAverageAtBase(int enum_type,int average_enum_type,int object_enum)=0;
		virtual void   InputChangeName(int enum_type,int enum_type_old)=0;
		virtual void   ComputeBasalStress(Vector<IssmDouble>* sigma_b)=0;
		virtual void   ComputeStrainRate(Vector<IssmDouble>* eps)=0;
		virtual void   ComputeStressTensor(void)=0;
		virtual void   ResultInterpolation(int* pinterpolation,int output_enum)=0;
		virtual void   ResultToVector(Vector<IssmDouble>* vector,int output_enum)=0;
		virtual void   Update(int index, IoModel* iomodel,int analysis_counter,int analysis_type,int finite_element)=0;
		virtual void   InputDuplicate(int original_enum,int new_enum)=0;
		virtual void   InputCreate(IssmDouble* vector,IoModel* iomodel,int M,int N,int vector_type,int vector_enum,int code)=0;
		virtual void   InputUpdateFromSolutionOneDofCollapsed(IssmDouble* solution,int inputenum)=0;
		virtual void   InputUpdateFromSolutionOneDof(IssmDouble* solution,int inputenum)=0;

		virtual int    NodalValue(IssmDouble* pvalue, int index, int natureofdataenum)=0;
		virtual int    NumberofNodesVelocity(void)=0;
		virtual int    NumberofNodesPressure(void)=0;
		virtual Gauss* NewGauss(void)=0;
		virtual Gauss* NewGauss(int order)=0;
      virtual Gauss* NewGauss(IssmDouble* xyz_list, IssmDouble* xyz_list_front,int order)=0;
      virtual Gauss* NewGauss(IssmDouble* xyz_list, IssmDouble* xyz_list_front,int order_horiz,int order_vert)=0;
      virtual Gauss* NewGauss(int point1,IssmDouble fraction1,IssmDouble fraction2,bool mainlyfloating,int order)=0;
		virtual Gauss* NewGaussBase(int order)=0;
		virtual Gauss* NewGaussLine(int vertex1,int vertex2,int order)=0;
		virtual Gauss* NewGaussTop(int order)=0;
		virtual ElementVector*  NewElementVector(int approximation_enum=NoneApproximationEnum)=0;
		virtual ElementMatrix*  NewElementMatrix(int approximation_enum=NoneApproximationEnum)=0;
		virtual void   InputScale(int enum_type,IssmDouble scale_factor)=0;
		virtual void   GetVectorFromInputs(Vector<IssmDouble>* vector, int name_enum)=0;
		virtual IssmDouble TimeAdapt()=0;
		virtual void   PositiveDegreeDay(IssmDouble* pdds,IssmDouble* pds,IssmDouble signorm)=0;
		virtual void   Delta18oParameterization(void)=0;
		virtual void   SmbGradients(void)=0;
	   virtual Element*   SpawnBasalElement(void)=0;
		virtual IssmDouble TMeltingPoint(IssmDouble pressure)=0;
		virtual void   ReduceMatrices(ElementMatrix* Ke,ElementVector* pe)=0;
		virtual void   ResetCoordinateSystem()=0;
		virtual IssmDouble StabilizationParameter(IssmDouble u, IssmDouble v, IssmDouble w, IssmDouble diameter, IssmDouble kappa)=0;
		virtual void   ValueP1OnGauss(IssmDouble* pvalue,IssmDouble* values,Gauss* gauss)=0;
		virtual void   ValueP1DerivativesOnGauss(IssmDouble* dvalue,IssmDouble* values,IssmDouble* xyz_list,Gauss* gauss)=0;
		virtual void   ViscousHeating(IssmDouble* pphi,IssmDouble* xyz_list,Gauss* gauss,Input* vx_input,Input* vy_input,Input* vz_input)=0;
		virtual void   ViscosityFS(IssmDouble* pviscosity,IssmDouble* xyz_list,Gauss* gauss,Input* vx_input,Input* vy_input,Input* vz_input)=0;
		virtual void   ViscosityHO(IssmDouble* pviscosity,IssmDouble* xyz_list,Gauss* gauss,Input* vx_input,Input* vy_input)=0;
		virtual void   ViscosityL1L2(IssmDouble* pviscosity,IssmDouble* xyz_list,Gauss* gauss,Input* vx_input,Input* vy_input,Input* surf)=0;
		virtual void   ViscositySSA(IssmDouble* pviscosity,IssmDouble* xyz_list,Gauss* gauss,Input* vx_input,Input* vy_input)=0;
		virtual void   ViscositySSADerivativeEpsSquare(IssmDouble* pmu_prime,IssmDouble* epsilon)=0;
		virtual void   ViscosityHODerivativeEpsSquare(IssmDouble* pmu_prime,IssmDouble* epsilon)=0;
		virtual void   ViscosityFSDerivativeEpsSquare(IssmDouble* pmu_prime,IssmDouble* epsilon)=0;
		virtual void   StrainRateSSA(IssmDouble* epsilon,IssmDouble* xyz_list,Gauss* gauss,Input* vx_input,Input* vy_input)=0;
		virtual void   StrainRateHO(IssmDouble* epsilon,IssmDouble* xyz_list,Gauss* gauss,Input* vx_input,Input* vy_input)=0;
		virtual void   StrainRateFS(IssmDouble* epsilon,IssmDouble* xyz_list,Gauss* gauss,Input* vx_input,Input* vy_input,Input* vz_input)=0;
		virtual int    VelocityInterpolation()=0;
		virtual int    PressureInterpolation()=0;
		virtual bool   IsZeroLevelset(int levelset_enum)=0;
		virtual void   ZeroLevelsetCoordinates(IssmDouble** pxyz_zero,IssmDouble* xyz_list,int levelsetenum)=0;

		#ifdef _HAVE_RESPONSES_
		virtual void   AverageOntoPartition(Vector<IssmDouble>* partition_contributions,Vector<IssmDouble>* partition_areas,IssmDouble* vertex_response,IssmDouble* qmu_part)=0;
		virtual void   MinVel(IssmDouble* pminvel)=0;
		virtual void   MaxVel(IssmDouble* pmaxvel)=0;
		virtual void   MinVx(IssmDouble* pminvx)=0;
		virtual void   MaxVx(IssmDouble* pmaxvx)=0;
		virtual void   MaxAbsVx(IssmDouble* pmaxabsvx)=0;
		virtual void   MinVy(IssmDouble* pminvy)=0;
		virtual void   MaxVy(IssmDouble* pmaxvy)=0;
		virtual void   MaxAbsVy(IssmDouble* pmaxabsvy)=0;
		virtual void   MinVz(IssmDouble* pminvz)=0;
		virtual void   MaxVz(IssmDouble* pmaxvz)=0;
		virtual void   MaxAbsVz(IssmDouble* pmaxabsvz)=0;
		virtual IssmDouble MassFlux(IssmDouble* segment)=0;
		virtual IssmDouble MassFlux(IssmDouble x1,IssmDouble y1, IssmDouble x2, IssmDouble y2,int segment_id)=0;
		virtual void   ElementResponse(IssmDouble* presponse,int response_enum)=0;
		virtual IssmDouble IceVolume(void)=0;
		virtual IssmDouble IceVolumeAboveFloatation(void)=0;
		virtual IssmDouble TotalSmb(void)=0;
		virtual IssmDouble Misfit(int modelenum,int observationenum,int weightsenum)=0;
		virtual int    VertexConnectivity(int vertexindex)=0;
		virtual void   VerticalSegmentIndices(int** pindices,int* pnumseg)=0;
		#endif

		#ifdef _HAVE_GIA_
		virtual void   GiaDeflection(Vector<IssmDouble>* wg,Vector<IssmDouble>* dwgdt,IssmDouble* x,IssmDouble* y)=0;
		#endif

		#ifdef _HAVE_CONTROL_
		virtual void   Gradj(Vector<IssmDouble>* gradient,int control_type,int control_index)=0;
		virtual IssmDouble ThicknessAbsMisfit(void)=0;
		virtual IssmDouble SurfaceAbsVelMisfit(void)=0;
		virtual IssmDouble SurfaceRelVelMisfit(void)=0;
		virtual IssmDouble SurfaceLogVelMisfit(void)=0;
		virtual IssmDouble SurfaceLogVxVyMisfit(void)=0;
		virtual IssmDouble SurfaceAverageVelMisfit(void)=0;
		virtual IssmDouble ThicknessAbsGradient(void)=0;
		virtual IssmDouble ThicknessAlongGradient(void)=0;
		virtual IssmDouble ThicknessAcrossGradient(void)=0;
		virtual IssmDouble BalancethicknessMisfit(void)=0;
		virtual IssmDouble RheologyBbarAbsGradient(void)=0;
		virtual IssmDouble DragCoefficientAbsGradient(void)=0;
		virtual void   ControlInputGetGradient(Vector<IssmDouble>* gradient,int enum_type,int control_index)=0;
		virtual void   ControlInputSetGradient(IssmDouble* gradient,int enum_type,int control_index)=0;
		virtual void   ControlInputScaleGradient(int enum_type, IssmDouble scale)=0;
		virtual void   ControlToVectors(Vector<IssmPDouble>* vector_control, Vector<IssmPDouble>* vector_gradient,int control_enum)=0;
		virtual void   GetVectorFromControlInputs(Vector<IssmDouble>* gradient,int control_enum,int control_index,const char* data)=0;
		virtual void   SetControlInputsFromVector(IssmDouble* vector,int control_enum,int control_index)=0;
		virtual void   InputControlUpdate(IssmDouble scalar,bool save_parameter)=0;
		#endif

		virtual void UpdateConstraintsExtrudeFromBase(void)=0;
		virtual void UpdateConstraintsExtrudeFromTop(void)=0;

		#ifdef _HAVE_THERMAL_
		virtual void UpdateBasalConstraintsEnthalpy(void)=0;
		virtual void ComputeBasalMeltingrate(void)=0;
		virtual void DrainWaterfraction(IssmDouble* drainrate_element)=0;
		#endif

		#ifdef _HAVE_HYDROLOGY_
		virtual void GetHydrologyDCInefficientHmax(IssmDouble* ph_max, Node* innode)=0;
		virtual void GetHydrologyDCInefficientHmax(IssmDouble* ph_max, int index)=0;
		virtual void GetHydrologyTransfer(Vector<IssmDouble>* transfer)=0; 
		virtual void HydrologyEPLGetMask(Vector<IssmDouble>* mask)=0;
		virtual void HydrologyEPLGetActive(Vector<IssmDouble>* active)=0;
		virtual void ComputeEPLThickness(void)=0;
		#endif

		#ifdef _HAVE_GROUNDINGLINE_
		virtual void   MigrateGroundingLine(IssmDouble* sheet_ungrounding)=0;
		virtual void   PotentialUngrounding(Vector<IssmDouble>* potential_sheet_ungrounding)=0;
		virtual int    UpdatePotentialUngrounding(IssmDouble* potential_sheet_ungrounding,Vector<IssmDouble>* vec_nodes_on_iceshelf,IssmDouble* nodes_on_iceshelf)=0;
		#endif

};
#endif
