/*! \file AdjointHorizAnalysis.h 
 *  \brief: header file for generic external result object
 */

#ifndef _AdjointHorizAnalysis_
#define _AdjointHorizAnalysis_

/*Headers*/
#include "./Analysis.h"

class AdjointHorizAnalysis: public Analysis{

	public:
		/*Model processing*/
		int  DofsPerNode(int** doflist,int meshtype,int approximation);
		void UpdateParameters(Parameters* parameters,IoModel* iomodel,int solution_enum,int analysis_enum);
		void UpdateElements(Elements* elements,IoModel* iomodel,int analysis_counter,int analysis_type);
		void CreateNodes(Nodes* nodes,IoModel* iomodel);
		void CreateConstraints(Constraints* constraints,IoModel* iomodel);
		void CreateLoads(Loads* loads, IoModel* iomodel);

		/*Finite element Analysis*/
		ElementMatrix* CreateKMatrix(Element* element);
		ElementMatrix* CreateKMatrixSSA(Element* element);
		ElementMatrix* CreateKMatrixHO(Element* element);
		ElementMatrix* CreateKMatrixFS(Element* element);
		ElementVector* CreatePVector(Element* element);
		ElementVector* CreatePVectorSSA(Element* element);
		ElementVector* CreatePVectorHO(Element* element);
		ElementVector* CreatePVectorFS(Element* element);
		void GetSolutionFromInputs(Vector<IssmDouble>* solution,Element* element);
		void InputUpdateFromSolution(IssmDouble* solution,Element* element);
		void InputUpdateFromSolutionHoriz(IssmDouble* solution,Element* element);
		void InputUpdateFromSolutionFS(IssmDouble* solution,Element* element);
};
#endif
