/*! \file StressbalanceAnalysis.h 
 *  \brief: header file for generic external result object
 */

#ifndef _StressbalanceAnalysis_
#define _StressbalanceAnalysis_

/*Headers*/
#include "./Analysis.h"

class StressbalanceAnalysis: public Analysis{

	public:
		/*Model processing*/
		int  DofsPerNode(int** doflist,int meshtype,int approximation);
		void UpdateParameters(Parameters* parameters,IoModel* iomodel,int solution_enum,int analysis_enum);
		void UpdateElements(Elements* elements,IoModel* iomodel,int analysis_counter,int analysis_type);
		void CreateNodes(Nodes* nodes,IoModel* iomodel);
		void CreateConstraints(Constraints* constraints,IoModel* iomodel);
		void CreateLoads(Loads* loads, IoModel* iomodel);

		/*Finite element Analysis*/
		ElementMatrix* CreateKMatrix(Element* element);
		ElementVector* CreatePVector(Element* element);
		void GetSolutionFromInputs(Vector<IssmDouble>* solution,Element* element);
		void GetSolutionFromInputsHoriz(Vector<IssmDouble>* solution,Element* element);
		void InputUpdateFromSolution(IssmDouble* solution,Element* element);

		/*SSA*/
		ElementMatrix* CreateKMatrixSSA(Element* element);
		ElementMatrix* CreateKMatrixSSAViscous(Element* element);
		ElementMatrix* CreateKMatrixSSAFriction(Element* element);
		ElementVector* CreatePVectorSSA(Element* element);
		ElementVector* CreatePVectorSSADrivingStress(Element* element);
		ElementVector* CreatePVectorSSAFront(Element* element);
		void GetBSSA(IssmDouble* B,Element* element,IssmDouble* xyz_list,Gauss* gauss);
		void GetBSSAFriction(IssmDouble* B,Element* element,IssmDouble* xyz_list,Gauss* gauss);
		void GetBSSAprime(IssmDouble* B,Element* element,IssmDouble* xyz_list,Gauss* gauss);
		void InputUpdateFromSolutionSSA(IssmDouble* solution,Element* element);
		/*L1L2*/
		ElementVector* CreatePVectorL1L2(Element* element);
		ElementVector* CreatePVectorL1L2DrivingStress(Element* element);
		ElementVector* CreatePVectorL1L2Front(Element* element);
		void InputUpdateFromSolutionL1L2(IssmDouble* solution,Element* element);
		/*HO*/
		ElementMatrix* CreateKMatrixHO(Element* element);
		ElementMatrix* CreateKMatrixHOViscous(Element* element);
		ElementMatrix* CreateKMatrixHOFriction(Element* element);
		ElementVector* CreatePVectorHO(Element* element);
		ElementVector* CreatePVectorHODrivingStress(Element* element);
		ElementVector* CreatePVectorHOFront(Element* element);
		void GetBHO(IssmDouble* B,Element* element,IssmDouble* xyz_list,Gauss* gauss);
		void GetBHOprime(IssmDouble* B,Element* element,IssmDouble* xyz_list,Gauss* gauss);
		void InputUpdateFromSolutionHO(IssmDouble* solution,Element* element);
		/*FS*/
		ElementMatrix* CreateKMatrixFS(Element* element);
		ElementMatrix* CreateKMatrixFSViscous(Element* element);
		ElementMatrix* CreateKMatrixFSFriction(Element* element);
		ElementVector* CreatePVectorFS(Element* element);
		ElementVector* CreatePVectorFSViscous(Element* element);
		ElementVector* CreatePVectorFSShelf(Element* element);
		ElementVector* CreatePVectorFSFront(Element* element);
		void GetBFS(IssmDouble* B,Element* element,int dim,IssmDouble* xyz_list,Gauss* gauss);
		void GetBFSprime(IssmDouble* B,Element* element,int dim,IssmDouble* xyz_list,Gauss* gauss);
		void GetSolutionFromInputsFS(Vector<IssmDouble>* solution,Element* element);
		void InputUpdateFromSolutionFS(IssmDouble* solution,Element* element);
		/*Coupling*/
		void InputUpdateFromSolutionHOFS(IssmDouble* solution,Element* element);
		void InputUpdateFromSolutionSSAFS(IssmDouble* solution,Element* element);
		void InputUpdateFromSolutionSSAHO(IssmDouble* solution,Element* element);
};
#endif
