#
########### Configuration file for Eric Larour's Jenkins run on Windows ############

#-------------------------------#
# 1: ISSM general configuration #
#-------------------------------#

#Nightly run name
NAME="ISSM matlab tests on Windows"

#ISSM Architecture
ISSM_ARCH="linux-gnu-amd64"

#ISSM CONFIGURATION 
ISSM_CONFIG='--prefix=$ISSM_DIR\
	--with-matlab-dir=$MATLAB_DIR \
	--with-triangle-dir=$ISSM_DIR/externalpackages/triangle/install \
	--with-metis-dir=$ISSM_DIR/externalpackages/metis/install \
	--with-mpi-include=$ISSM_DIR/externalpackages/mpich/install/include  \
	--with-mpi-libflags="-L$ISSM_DIR/externalpackages/mpich/install/lib/ -lmpich" \
	--with-petsc-dir=$ISSM_DIR/externalpackages/petsc/install \
	--with-petsc-arch=$ISSM_ARCH \
	--with-python-dir=$ISSM_DIR/externalpackages/python/install\
	--with-python-numpy-dir=$ISSM_DIR/externalpackages/python/install/lib/python2.7/site-packages/numpy/core/include/numpy\
	--with-mumps-dir=$ISSM_DIR/externalpackages/petsc/install/ \
	--with-blas-lapack-dir=$ISSM_DIR/externalpackages/petsc/install \
	--with-chaco-dir="$ISSM_DIR/externalpackages/chaco/install" \
	--with-numthreads=18 \
	--with-cxxoptflags="-mtune=barcelona -ffast-math -O3 -msse4.2 -Wno-write-strings "\
	--with-graphics-lib="/usr/lib/x86_64-linux-gnu/libX11.so" \
	--with-dakota-dir=$ISSM_DIR/externalpackages/dakota/install \
	--with-boost-dir=$ISSM_DIR/externalpackages/boost/install/ \
	--with-tao-dir=$ISSM_DIR/externalpackages/tao/install \
	--enable-debugging '

#MATLAB path
MATLAB_PATH="/usr/local/matlab80/"

#PYTHON and MATLAB testing
MATLAB_TEST=1
PYTHON_TEST=1

#execution path used for parallel runs
EXECUTION_PATH=$ISSM_DIR/execution

#-----------------------------------#
# 3: External packages installation #
#-----------------------------------#

#ISSM_EXTERNALPACKAGES can have 3 values:
# - "install" install all external packages listed below
# - "copy"    copy existing directories (EXTERNALPACKAGESDIR)
# - "none"    leave external packages as is
#             ->skip to section 4
ISSM_EXTERNALPACKAGES="install"
EXTERNALPACKAGESDIR=$ISSM_DIR/externalpackages

#List of external pakages to be installed and their installation scripts
EXTERNALPACKAGES="autotools install.sh                
						matlab    install.sh                
						mpich     install-3.0-linux64.sh    
						cmake     install.sh                
						petsc     install-3.4-linux64.sh    
						triangle  install-linux64.sh        
						boost     install.sh                
						dakota    install-5.3.1-linux64.sh  
						tao       install-2.2.sh
						chaco     install.sh 
						python        install-2.7.3-linux64.sh    
						nose          install-linux64-python2.sh  
						blas          install-linux64.sh          
						lapack        install-linux64.sh          
						git           install.sh                  
						numpy         install-linux64.sh          
						scipy         install-linux64.sh          
						hdf5          install.sh                  
						netcdf        install.sh                  
						netcdf-python install.sh
						shell2junit install.sh"


#---------------------#
# 4: ISSM Compilation #
#---------------------#

#ISSM_COMPILATION can have 2 values:
# - "yes" compile ISSM
# - "no"  do not compile ISSM
ISSM_COMPILATION="yes"

#----------------------#
# 5: Mail notification #
#----------------------#

#Mail delivery. If SKIPMAIL="no", the html nightly run report will be
#sent to the adresses present in $ISSM_DIR/cron/mailinglist.
SKIPMAIL="no"

#Sender email address
EMAIL_ADRESS="eric.larour@jpl.nasa.gov"

#Mailing list
MAILINGLIST="eric.larour@jpl.nasa.gov"

#------------------------#
# 6: Nightly run options #
#------------------------#

#number of cpus used in ISSM installation and compilation (one is usually
#safer as some packages are very sensitive to parallel compilation)
NUMCPUS_INSTALL=8

#number of cpus used in the nightly runs.
NUMCPUS_RUN=8

#Nightly run options. The matlab routine runme.m will be called
#as follows: runme($MATLAB_NROPTIONS). The options must be understandable
#by Matlab and runme.m
#ex: "'id',[101 102 103]"
MATLAB_NROPTIONS=""
PYTHON_NROPTIONS=""
