/*! \file Tria.h 
 *  \brief: header file for tria object
 */

#ifndef _TRIA_H_
#define _TRIA_H_

/*Headers:*/
/*{{{*/
#include "./Element.h"
#include "./ElementHook.h"
#include "./TriaRef.h"
class Parameters;
class Inputs;
class IoModel;
class Results;
class Node;
class Material;
class Matpar;
class Seg;
class ElementMatrix;
class ElementVector;
class Vertex;
class GaussTria;

#include "../../shared/Exceptions/exceptions.h"
#include "../../shared/Enum/Enum.h"
/*}}}*/

class Tria: public Element,public ElementHook,public TriaRef{

	public:

		int          id;
		int          sid;

		Node       **nodes;                       // nodes
		Vertex     **vertices;                    // 3 vertices
		Material    *material;                    // 1 material ice
		Matpar      *matpar;                      // 1 material parameter

		Parameters  *parameters;                  //pointer to solution parameters
		Inputs      *inputs;

		/*Tria constructors, destructors {{{*/
		Tria();
		Tria(int tria_id,int tria_sid,int i, IoModel* iomodel,int nummodels);
		~Tria();
		/*}}}*/
		/*Object virtual functions definitions:{{{ */
		void    Echo();
		void    DeepEcho();
		int     Id();
		int     ObjectEnum();
		Object *copy();
		/*}}}*/
		/*Update virtual functions resolution: {{{*/
		void  InputUpdateFromVector(IssmDouble* vector, int name, int type);
		#ifdef _HAVE_DAKOTA_
		void  InputUpdateFromVectorDakota(IssmDouble* vector, int name, int type);
		void  InputUpdateFromMatrixDakota(IssmDouble* matrix, int nows, int ncols, int name, int type);
		#endif
		void  InputUpdateFromConstant(IssmDouble constant, int name);
		void  InputUpdateFromConstant(int constant, int name);
		void  InputUpdateFromConstant(bool constant, int name);
		void  InputUpdateFromIoModel(int index, IoModel* iomodel);
		/*}}}*/
		/*Element virtual functions definitions: {{{*/
		IssmDouble  CharacteristicLength(void);
		void        ComputeBasalStress(Vector<IssmDouble>* sigma_b);
		void        ComputeStrainRate(Vector<IssmDouble>* eps);
		void        ComputeStressTensor();
		void        ComputeSurfaceNormalVelocity();
		void        Configure(Elements* elements,Loads* loads,Nodes* nodesin,Vertices* verticesin,Materials* materials,Parameters* parameters);
		void        SetCurrentConfiguration(Elements* elements,Loads* loads,Nodes* nodes,Materials* materials,Parameters* parameters);
		void        SetwiseNodeConnectivity(int* d_nz,int* o_nz,Node* node,bool* flags,int* flagsindices,int set1_enum,int set2_enum);
		void        CreateDVector(Vector<IssmDouble>* df);
		void        CreateJacobianMatrix(Matrix<IssmDouble>* Jff);
		void        DeleteMaterials(void);
		void        Delta18oParameterization(void);
		void        ElementSizes(IssmDouble* hx,IssmDouble* hy,IssmDouble* hz){_error_("not implemented yet");};
		void        EnthalpyToThermal(IssmDouble* ptemperature,IssmDouble* pwaterfraction,IssmDouble enthalpy,IssmDouble pressure){_error_("not implemented yet");};
		void        FindParam(int* pvalue,int paramenum);
		void        FindParam(IssmDouble* pvalue,int paramenum);
		void        FindParam(int** pvalues,int* psize,int paramenum);
		int         FiniteElement(void);
		Element*    GetBasalElement(void){_error_("not implemented yet");};
		void	      GetDofList(int** pdoflist,int approximation_enum,int setenum);
		void	      GetDofListVelocity(int** pdoflist,int setenum);
		void	      GetDofListPressure(int** pdoflist,int setenum);
		int         GetNodeIndex(Node* node);
		void        GetNodesSidList(int* sidlist);
		void        GetNodesLidList(int* lidlist);
		int         GetNumberOfNodes(void);
		int         GetNumberOfNodesPressure(void);
		int         GetNumberOfNodesVelocity(void);
		int         GetNumberOfVertices(void);
		int         Sid();
		bool        IsOnBed();
		bool        IsOnSurface();
		bool        HasEdgeOnBed();
		bool        HasNodeOnBed();
		bool        HasEdgeOnSurface();
		bool        HasNodeOnSurface();
		void        EdgeOnSurfaceIndices(int* pindex1,int* pindex);
		void        EdgeOnBedIndices(int* pindex1,int* pindex);
		int         EdgeOnBedIndex();
		int         EdgeOnSurfaceIndex();
		bool        IsFloating();
		bool        IsNodeOnShelfFromFlags(IssmDouble* flags);
		int         NumberofNodesVelocity(void);
		int         NumberofNodesPressure(void);
		bool        NoIceInElement();
		void        GetSolutionFromInputsOneDof(Vector<IssmDouble>* solution,int enum_type);
		void        GetVectorFromInputs(Vector<IssmDouble>* vector, int name_enum);
		void        GetVerticesCoordinates(IssmDouble** pxyz_list);
		void        GetVerticesCoordinatesBase(IssmDouble** pxyz_list){_error_("not implemented yet");};
		void        GetVerticesCoordinatesTop(IssmDouble** pxyz_list){_error_("not implemented yet");};
		void        InputCreate(IssmDouble* vector,IoModel* iomodel,int M,int N,int vector_type,int vector_enum,int code);
		void        InputDepthAverageAtBase(int enum_type,int average_enum_type,int object_enum=MeshElementsEnum);
		void        InputDuplicate(int original_enum,int new_enum);
		void        InputScale(int enum_type,IssmDouble scale_factor);
		void        MaterialUpdateFromTemperature(void){_error_("not implemented yet");};
		int         NodalValue(IssmDouble* pvalue, int index, int natureofdataenum);
		void        PositiveDegreeDay(IssmDouble* pdds,IssmDouble* pds,IssmDouble signorm);
		void        ResultInterpolation(int* pinterpolation,int output_enum);
		void        ResultToVector(Vector<IssmDouble>* vector,int output_enum);
		void        ReduceMatrices(ElementMatrix* Ke,ElementVector* pe);
		void        ResetCoordinateSystem(void);
		void	      SmbGradients();
	   Element*    SpawnBasalElement(void);
		IssmDouble  TMeltingPoint(IssmDouble pressure);
		int         VelocityInterpolation();
		IssmDouble  PureIceEnthalpy(IssmDouble pressure){_error_("not implemented yet");};
		int         PressureInterpolation();
		IssmDouble  SurfaceArea(void);
		void        Update(int index, IoModel* iomodel,int analysis_counter,int analysis_type,int finitelement);
		IssmDouble  TimeAdapt();
		void        ZeroLevelsetCoordinates(IssmDouble** pxyz_zero,IssmDouble* xyz_list,int levelsetenum);
		bool        IsZeroLevelset(int levelset_enum);

		#ifdef _HAVE_RESPONSES_
		void       AverageOntoPartition(Vector<IssmDouble>* partition_contributions,Vector<IssmDouble>* partition_areas,IssmDouble* vertex_response,IssmDouble* qmu_part);
		IssmDouble IceVolume(void);
		IssmDouble IceVolumeAboveFloatation(void);
		IssmDouble TotalSmb(void);
		void       MinVel(IssmDouble* pminvel);
		void       MinVx(IssmDouble* pminvx);
		void       MinVy(IssmDouble* pminvy);
		void       MinVz(IssmDouble* pminvz);
		IssmDouble MassFlux(IssmDouble* segment);
		IssmDouble MassFlux(IssmDouble x1,IssmDouble y1, IssmDouble x2, IssmDouble y2,int segment_id);
		void       MaxAbsVx(IssmDouble* pmaxabsvx);
		void       MaxAbsVy(IssmDouble* pmaxabsvy);
		void       MaxAbsVz(IssmDouble* pmaxabsvz);
		void       ElementResponse(IssmDouble* presponse,int response_enum);
		void       MaxVel(IssmDouble* pmaxvel);
		void       MaxVx(IssmDouble* pmaxvx);
		void       MaxVy(IssmDouble* pmaxvy);
		void       MaxVz(IssmDouble* pmaxvz);
		IssmDouble Misfit(int modelenum,int observationenum,int weightsenum);
		#endif

		#ifdef _HAVE_GIA_
		void   GiaDeflection(Vector<IssmDouble>* wg,Vector<IssmDouble>* dwgdt,IssmDouble* x,IssmDouble* y);
		#endif

		#ifdef _HAVE_CONTROL_
		IssmDouble DragCoefficientAbsGradient(void);
		void       GradientIndexing(int* indexing,int control_index);
		void       Gradj(Vector<IssmDouble>* gradient,int control_type,int control_index);
		void       GradjBGradient(Vector<IssmDouble>* gradient,int control_index);
		void       GradjDGradient(Vector<IssmDouble>* gradient,int control_index);
		void       GradjBSSA(Vector<IssmDouble>* gradient,int control_index);
		void       GradjDSSA(Vector<IssmDouble>* gradient,int control_index);
		void       GradjDragSSA(Vector<IssmDouble>* gradient,int control_index);
		void       GradjDragFS(Vector<IssmDouble>* gradient,int control_index);
		void       GradjDragGradient(Vector<IssmDouble>* gradient,int control_index);
		void       GradjDhDtBalancedthickness(Vector<IssmDouble>* gradient,int control_index);
		void       GradjVxBalancedthickness(Vector<IssmDouble>* gradient,int control_index);
		void       GradjVyBalancedthickness(Vector<IssmDouble>* gradient,int control_index);
		void       GradjThicknessBalancethicknessSoft(Vector<IssmDouble>* gradient,int control_index);
		void       GetVectorFromControlInputs(Vector<IssmDouble>* gradient,int control_enum,int control_index,const char* data);
		void       SetControlInputsFromVector(IssmDouble* vector,int control_enum,int control_index);
		void       ControlInputGetGradient(Vector<IssmDouble>* gradient,int enum_type,int control_index);
		void       ControlInputScaleGradient(int enum_type,IssmDouble scale);
		void       ControlInputSetGradient(IssmDouble* gradient,int enum_type,int control_index);
		void       ControlToVectors(Vector<IssmPDouble>* vector_control, Vector<IssmPDouble>* vector_gradient,int control_enum);
		IssmDouble RheologyBbarAbsGradient(void);
		IssmDouble ThicknessAbsMisfit(void);
		IssmDouble SurfaceAbsVelMisfit(void);
		IssmDouble ThicknessAbsGradient(void);
		IssmDouble ThicknessAlongGradient(void);
		IssmDouble ThicknessAcrossGradient(void);
		IssmDouble BalancethicknessMisfit(void);
		IssmDouble SurfaceRelVelMisfit(void);
		IssmDouble SurfaceLogVelMisfit(void);
		IssmDouble SurfaceLogVxVyMisfit(void);
		IssmDouble SurfaceAverageVelMisfit(void);
		void       InputControlUpdate(IssmDouble scalar,bool save_parameter);
		#endif

		#ifdef _HAVE_GROUNDINGLINE_
		void   PotentialUngrounding(Vector<IssmDouble>* potential_sheet_ungrounding);
		void   MigrateGroundingLine(IssmDouble* sheet_ungrounding);
		int    UpdatePotentialUngrounding(IssmDouble* vertices_potentially_ungrounding,Vector<IssmDouble>* vec_nodes_on_iceshelf,IssmDouble* nodes_on_iceshelf);
		#endif

		/*}}}*/
		/*Tria specific routines:{{{*/
		void           AddBasalInput(int input_enum, IssmDouble* values, int interpolation_enum);
		void           AddInput(int input_enum, IssmDouble* values, int interpolation_enum);
		void           AddMaterialInput(int input_enum, IssmDouble* values, int interpolation_enum);
		ElementMatrix* CreateKMatrix(void);
		ElementMatrix* CreateKMatrixBalancethickness(void);
		ElementMatrix* CreateKMatrixBalancethickness_DG(void);
		ElementMatrix* CreateKMatrixBalancethickness_CG(void);
		ElementMatrix* CreateKMatrixBalancevelocity(void);
		ElementMatrix* CreateKMatrixSmoothedSlope(void);
		ElementMatrix* CreateKMatrixMelting(void);
		ElementMatrix* CreateKMatrixMasstransport(void);
		ElementMatrix* CreateKMatrixMasstransport_CG(void);
		ElementMatrix* CreateKMatrixMasstransport_DG(void);
		ElementMatrix* CreateKMatrixExtrusion(void);
		ElementMatrix* CreateKMatrixExtrusionVolume(void);
		ElementMatrix* CreateKMatrixExtrusionSurface(void);
		ElementMatrix* CreateKMatrixExtrusionBed(void);
		ElementMatrix* CreateKMatrixFreeSurfaceTop(void);
		ElementMatrix* CreateKMatrixFreeSurfaceTop1D(void);
		ElementMatrix* CreateKMatrixFreeSurfaceBase(void);
		ElementMatrix* CreateKMatrixFreeSurfaceBase1D(void);
		ElementMatrix* CreateMassMatrix(void);
		ElementMatrix* CreateBasalMassMatrix(void);
		ElementVector* CreatePVector(void);
		ElementVector* CreatePVectorBalancethickness(void);
		ElementVector* CreatePVectorBalancethickness_DG(void);
		ElementVector* CreatePVectorBalancethickness_CG(void);
		ElementVector* CreatePVectorBalancevelocity(void);
		ElementVector* CreatePVectorSmoothedSlopeX(void);
		ElementVector* CreatePVectorSmoothedSlopeY(void);
		ElementVector* CreatePVectorMasstransport(void);
		ElementVector* CreatePVectorMasstransport_CG(void);
		ElementVector* CreatePVectorMasstransport_DG(void);
		ElementVector* CreatePVectorFreeSurfaceTop(void);
		ElementVector* CreatePVectorFreeSurfaceTop1D(void);
		ElementVector* CreatePVectorFreeSurfaceBase(void);
		ElementVector* CreatePVectorFreeSurfaceBase1D(void);
		ElementVector* CreatePVectorL2Projection(void);
		ElementVector* CreatePVectorL2ProjectionBase(void);
		IssmDouble     EnthalpyDiffusionParameter(IssmDouble enthalpy,IssmDouble pressure){_error_("not implemented");};
		IssmDouble     EnthalpyDiffusionParameterVolume(int numvertices,IssmDouble* enthalpy,IssmDouble* pressure){_error_("not implemented");};
		IssmDouble     GetArea(void);
		void           GetAreaCoordinates(IssmDouble *area_coordinates,IssmDouble* xyz_zero,IssmDouble* xyz_list,int numpoints);
		int            GetElementType(void);

		void	         GetVertexPidList(int* doflist);
		void           GetVertexSidList(int* sidlist);
		void           GetConnectivityList(int* connectivity);
		void           GetGroundedPart(int* point1,IssmDouble* fraction1, IssmDouble* fraction2,bool* mainlyfloating);
		IssmDouble     GetGroundedPortion(IssmDouble* xyz_list);
		IssmDouble     GetZcoord(Gauss* gauss){_error_("not implemented");};
		void           NormalSection(IssmDouble* normal,IssmDouble* xyz_list);
		void           NormalTop(IssmDouble* normal,IssmDouble* xyz_list){_error_("not implemented yet");};
		void           NormalBase(IssmDouble* normal,IssmDouble* xyz_list){_error_("not implemented yet");};
		IssmDouble     GetMaterialParameter(int enum_in);
		Input*         GetInput(int inputenum);
		Input*         GetMaterialInput(int inputenum);
		void           GetInputListOnVertices(IssmDouble* pvalue,int enumtype);
		void           GetInputListOnVertices(IssmDouble* pvalue,int enumtype,IssmDouble defaultvalue);
		void           GetInputListOnVertices(IssmDouble* pvalue,int enumtype,IssmDouble defaultvalue,int index); //TO BE REMOVED
		void           GetInputListOnNodes(IssmDouble* pvalue,int enumtype);
		void           GetInputListOnNodes(IssmDouble* pvalue,int enumtype,IssmDouble defaultvalue);
		void           GetInputValue(IssmDouble* pvalue,Node* node,int enumtype);
		void           GetInputValue(bool* pvalue,int enum_type);
		void           GetInputValue(int* pvalue,int enum_type);
		void           GetInputValue(IssmDouble* pvalue,int enum_type);
		void           GetMaterialInputValue(IssmDouble* pvalue,Node* node,int enumtype);
		void           GetStrainRate2d(IssmDouble* epsilon,IssmDouble* xyz_list,Gauss* gauss, Input* vx_input, Input* vy_input);
		void	         InputChangeName(int enum_type,int enum_type_old);
		void	         InputUpdateFromSolutionOneDof(IssmDouble* solution,int enum_type);
		void	         InputUpdateFromSolutionOneDofCollapsed(IssmDouble* solution,int enum_type){_error_("not implemented yet");};
		bool	         IsInput(int name);
		void           JacobianDeterminant(IssmDouble*  pJdet, IssmDouble* xyz_list,Gauss* gauss);
		void           JacobianDeterminantSurface(IssmDouble*  pJdet, IssmDouble* xyz_list,Gauss* gauss);
		void           JacobianDeterminantBase(IssmDouble* pJdet,IssmDouble* xyz_list_base,Gauss* gauss){_error_("not implemented yet");};
		void           JacobianDeterminantTop(IssmDouble* pJdet,IssmDouble* xyz_list_base,Gauss* gauss){_error_("not implemented yet");};
		IssmDouble     MinEdgeLength(IssmDouble* xyz_list){_error_("not implemented yet");};
		Gauss*         NewGauss(void);
		Gauss*         NewGauss(int order);
      Gauss*         NewGauss(IssmDouble* xyz_list, IssmDouble* xyz_list_front,int order);
      Gauss*         NewGauss(IssmDouble* xyz_list, IssmDouble* xyz_list_front,int order_horiz,int order_vert){_error_("not implemented yet");};
		Gauss*         NewGaussBase(int order){_error_("not implemented yet");};
		Gauss*         NewGaussTop(int order){_error_("not implemented yet");};
		ElementVector* NewElementVector(int approximation_enum);
		ElementMatrix* NewElementMatrix(int approximation_enum);
		void           NodalFunctions(IssmDouble* basis,Gauss* gauss);
		void           NodalFunctionsDerivatives(IssmDouble* dbasis,IssmDouble* xyz_list,Gauss* gauss);
		void           NodalFunctionsDerivativesVelocity(IssmDouble* dbasis,IssmDouble* xyz_list,Gauss* gauss);
		void           NodalFunctionsVelocity(IssmDouble* basis,Gauss* gauss);
		void           NodalFunctionsPressure(IssmDouble* basis,Gauss* gauss);
		void	         SetClone(int* minranks);
		Seg*	         SpawnSeg(int index1,int index2);
		IssmDouble     StabilizationParameter(IssmDouble u, IssmDouble v, IssmDouble w, IssmDouble diameter, IssmDouble kappa){_error_("not implemented yet");};
		void           TransformLoadVectorCoord(ElementVector* pe,int transformenum);
		void           TransformLoadVectorCoord(ElementVector* pe,int* transformenum_list);
		void           TransformLoadVectorCoord(ElementVector* pe,int numnodes,int transformenum){_error_("not implemented yet");};
		void           TransformLoadVectorCoord(ElementVector* pe,int numnodes,int* transformenum_list){_error_("not implemented yet");};
		void           TransformSolutionCoord(IssmDouble* values,int transformenum);
		void           TransformSolutionCoord(IssmDouble* values,int* transformenum_list);
		void           TransformSolutionCoord(IssmDouble* values,int numnodes,int transformenum){_error_("not implemented yet");};
		void           TransformSolutionCoord(IssmDouble* values,int numnodes,int* transformenum_list){_error_("not implemented yet");};
		void           TransformStiffnessMatrixCoord(ElementMatrix* Ke,int transformenum);
		void           TransformStiffnessMatrixCoord(ElementMatrix* Ke,int* transformenum_list);
		void           TransformStiffnessMatrixCoord(ElementMatrix* Ke,int numnodes,int transformenum){_error_("not implemented yet");};
		void           TransformStiffnessMatrixCoord(ElementMatrix* Ke,int numnodes,int* transformenum_list){_error_("not implemented yet");};
		void           ViscousHeating(IssmDouble* pphi,IssmDouble* xyz_list,Gauss* gauss,Input* vx_input,Input* vy_input,Input* vz_input){_error_("not implemented yet");};
		void           ViscosityFS(IssmDouble* pviscosity,IssmDouble* xyz_list,Gauss* gauss,Input* vx_input,Input* vy_input,Input* vz_input);
		void           ViscosityHO(IssmDouble* pviscosity,IssmDouble* xyz_list,Gauss* gauss,Input* vx_input,Input* vy_input){_error_("not implemented yet");};
		void           ViscositySSA(IssmDouble* pviscosity,IssmDouble* xyz_list,Gauss* gauss,Input* vx_input,Input* vy_input);

		#ifdef _HAVE_STRESSBALANCE_
		ElementMatrix* CreateKMatrixStressbalanceSSA(void);
		ElementMatrix* CreateKMatrixStressbalanceSSAViscous(void);
		ElementMatrix* CreateKMatrixStressbalanceSSAFriction(void);
		ElementMatrix* CreateKMatrixStressbalanceSIA(void);
		ElementMatrix* CreateKMatrixStressbalanceFS(void);
		ElementMatrix* CreateKMatrixStressbalanceFSViscous(void);
		ElementMatrix* CreateKMatrixStressbalanceFSFriction(void);
		ElementVector* CreatePVectorStressbalanceSSA(void);
		ElementVector* CreatePVectorStressbalanceSSADrivingStress(void);
		ElementVector* CreatePVectorStressbalanceSSAFront(void);
		ElementVector* CreatePVectorStressbalanceSIA(void);
		ElementVector* CreatePVectorStressbalanceFS(void);
		ElementVector* CreatePVectorStressbalanceFSFront(void);
		ElementVector* CreatePVectorStressbalanceFSViscous(void);
		void           PVectorGLSstabilization(ElementVector* pe);
		ElementVector* CreatePVectorStressbalanceFSShelf(void);
		ElementMatrix* CreateJacobianStressbalanceSSA(void);
		IssmDouble     GetYcoord(GaussTria* gauss);
		#endif

		#ifdef _HAVE_CONTROL_
		ElementMatrix* CreateKMatrixAdjointBalancethickness(void);
		ElementMatrix* CreateKMatrixAdjointSSA(void);
		ElementVector* CreatePVectorAdjointHoriz(void);
		ElementVector* CreatePVectorAdjointBalancethickness(void);
		#endif

		void UpdateConstraintsExtrudeFromBase(void);
		void UpdateConstraintsExtrudeFromTop(void);
		#ifdef _HAVE_THERMAL_
		void UpdateBasalConstraintsEnthalpy(void){_error_("not implemented yet");};
		void ComputeBasalMeltingrate(void){_error_("not implemented yet");};
		void DrainWaterfraction(IssmDouble* drainrate_element){_error_("not implemented yet");};
		#endif

		#ifdef _HAVE_HYDROLOGY_
		ElementMatrix* CreateKMatrixHydrologyShreve(void);
		ElementMatrix* CreateKMatrixHydrologyDCInefficient(void);
		ElementMatrix* CreateKMatrixHydrologyDCEfficient(void);
		ElementMatrix* CreateEPLDomainMassMatrix(void);
		ElementVector* CreatePVectorHydrologyShreve(void);
		ElementVector* CreatePVectorHydrologyDCInefficient(void);
		ElementVector* CreatePVectorHydrologyDCEfficient(void);
		ElementVector* CreatePVectorL2ProjectionEPL(void);
		void           CreateHydrologyWaterVelocityInput(void);
		void           GetHydrologyDCInefficientHmax(IssmDouble* ph_max, Node* innode);
		void           GetHydrologyDCInefficientHmax(IssmDouble* ph_max,int index);
		void           GetHydrologyTransfer(Vector<IssmDouble>* transfer);
		void           HydrologyEPLGetActive(Vector<IssmDouble>* active_vec);
		void           HydrologyEPLGetMask(Vector<IssmDouble>* vec_mask);
		void           ComputeEPLThickness(void);
		bool           AllActive(void);
		bool           AnyActive(void);
		#endif

		#ifdef _HAVE_DAMAGE_
		ElementMatrix* CreateKMatrixDamageEvolution(void);
		ElementMatrix* CreateKMatrixDamageEvolution_CG(void);
		ElementVector* CreatePVectorDamageEvolution(void);
		ElementVector* CreatePVectorDamageEvolution_CG(void);
		void           DamageEvolutionF(IssmDouble* flist);
		#endif


		/*}}}*/

};
#endif  /* _TRIA_H */
