/*!\file:  PentaRef.h
 * \brief abstract class for handling Penta oriented routines, like nodal functions, 
 * strain rate generation, etc ...
 */ 

#ifndef _PENTAREF_H_
#define _PENTAREF_H_

class Gauss;
class PentaRef{

	public: 
		int* element_type_list; //P1CG, P1DG, MINI, P2...
		int  element_type;

		PentaRef();
		PentaRef(const int nummodels);
		~PentaRef();

		/*Management*/
		void SetElementType(int type,int type_counter);

		/*Numerics*/
		void GetNodalFunctions(IssmDouble* basis, Gauss* gauss);
		void GetNodalFunctionsVelocity(IssmDouble* basis, Gauss* gauss);
		void GetNodalFunctionsPressure(IssmDouble* basis, Gauss* gauss);
		void GetNodalFunctionsDerivatives(IssmDouble* dbasis,IssmDouble* xyz_list,Gauss* gauss);
		void GetNodalFunctionsDerivativesVelocity(IssmDouble* dbasis,IssmDouble* xyz_list,Gauss* gauss);
		void GetNodalFunctionsDerivativesPressure(IssmDouble* dbasis,IssmDouble* xyz_list,Gauss* gauss);
		void GetNodalFunctionsDerivativesReference(IssmDouble* dbasis,Gauss* gauss);
		void GetNodalFunctionsP1(IssmDouble* l1l6, Gauss* gauss);
		void GetNodalFunctionsMINI(IssmDouble* l1l7, Gauss* gauss);
		void GetNodalFunctionsP1Derivatives(IssmDouble* dh1dh6,IssmDouble* xyz_list, Gauss* gauss);
		void GetNodalFunctionsMINIDerivatives(IssmDouble* dh1dh7,IssmDouble* xyz_list, Gauss* gauss);
		void GetNodalFunctionsP1DerivativesReference(IssmDouble* dl1dl6,Gauss* gauss);
		void GetNodalFunctionsMINIDerivativesReference(IssmDouble* dl1dl7,Gauss* gauss);
		void GetQuadJacobianDeterminant(IssmDouble*  Jdet, IssmDouble* xyz_list,Gauss* gauss);
		void GetJacobian(IssmDouble* J, IssmDouble* xyz_list,Gauss* gauss);
		void GetJacobianDeterminant(IssmDouble*  Jdet, IssmDouble* xyz_list,Gauss* gauss);
		void GetTriaJacobianDeterminant(IssmDouble*  Jdet, IssmDouble* xyz_list,Gauss* gauss);
		void GetSegmentJacobianDeterminant(IssmDouble*  Jdet, IssmDouble* xyz_list,Gauss* gauss);
		void GetJacobianInvert(IssmDouble*  Jinv, IssmDouble* xyz_list,Gauss* gauss);
		void GetBSSAHO(IssmDouble* B, IssmDouble* xyz_list, Gauss* gauss);
		void GetBSSAFS(IssmDouble* B, IssmDouble* xyz_list, Gauss* gauss);
		void GetBHO(IssmDouble* B, IssmDouble* xyz_list, Gauss* gauss);
		void GetBFSstrainrate(IssmDouble* B, IssmDouble* xyz_list, Gauss* gauss);
		void GetBFS(IssmDouble* B, IssmDouble* xyz_list, Gauss* gauss);
		void GetBFSGLS(IssmDouble* B, IssmDouble* xyz_list, Gauss* gauss);
		void GetBprimeSSAFS(IssmDouble* Bprime, IssmDouble* xyz_list, Gauss* gauss);
		void GetBprimeHO(IssmDouble* B, IssmDouble* xyz_list, Gauss* gauss);
		void GetBprimeFS(IssmDouble* B_prime, IssmDouble* xyz_list, Gauss* gauss);
		void GetBprimeFSGLS(IssmDouble* B_prime, IssmDouble* xyz_list, Gauss* gauss);
		void GetBprimeVert(IssmDouble* B, IssmDouble* xyz_list, Gauss* gauss);
		void GetBAdvec(IssmDouble* B_advec, IssmDouble* xyz_list, Gauss* gauss);
		void GetBConduct(IssmDouble* B_conduct, IssmDouble* xyz_list, Gauss* gauss);
		void GetBVert(IssmDouble* B, IssmDouble* xyz_list, Gauss* gauss);
		void GetBprimeAdvec(IssmDouble* Bprime_advec, IssmDouble* xyz_list, Gauss* gauss);
		void GetBHOFriction(IssmDouble* L, Gauss* gauss);
		void GetLFS(IssmDouble* LFS, Gauss* gauss);
		void GetLprimeFS(IssmDouble* LprimeFS, IssmDouble* xyz_list, Gauss* gauss);
		void GetLSSAFS(IssmDouble* LSSAFS, Gauss* gauss);
		void GetLprimeSSAFS(IssmDouble* LprimeSSAFS, IssmDouble* xyz_list, Gauss* gauss);
		void GetLFSSSA(IssmDouble* LFSSSA, Gauss* gauss);
		void GetLprimeFSSSA(IssmDouble* LprimeFSSSA, IssmDouble* xyz_list, Gauss* gauss);
		void GetInputValue(IssmDouble* pvalue,IssmDouble* plist, Gauss* gauss);
		void GetInputDerivativeValue(IssmDouble* pvalues, IssmDouble* plist,IssmDouble* xyz_list, Gauss* gauss);

		void BasalNodeIndices(int* pnumindices,int** pindices,int finiteelement);
		void SurfaceNodeIndices(int* pnumindices,int** pindices,int finiteelement);
		int  NumberofNodes(void);
		int  NumberofNodesVelocity(void);
		int  NumberofNodesPressure(void);
		int  VelocityInterpolation(void);
		int  PressureInterpolation(void);
};
#endif
