/*! \file StressbalanceVerticalAnalysis.h 
 *  \brief: header file for generic external result object
 */

#ifndef _StressbalanceVerticalAnalysis_
#define _StressbalanceVerticalAnalysis_

/*Headers*/
#include "./Analysis.h"

class StressbalanceVerticalAnalysis: public Analysis{

	public:
		/*Model processing*/
		int  DofsPerNode(int** doflist,int meshtype,int approximation);
		void UpdateParameters(Parameters* parameters,IoModel* iomodel,int solution_enum,int analysis_enum);
		void UpdateElements(Elements* elements,IoModel* iomodel,int analysis_counter,int analysis_type);
		void CreateNodes(Nodes* nodes,IoModel* iomodel);
		void CreateConstraints(Constraints* constraints,IoModel* iomodel);
		void CreateLoads(Loads* loads, IoModel* iomodel);

		/*Finite element Analysis*/
		ElementMatrix* CreateKMatrix(Element* element);
		ElementMatrix* CreateKMatrixVolume(Element* element);
		ElementMatrix* CreateKMatrixSurface(Element* element);
		ElementVector* CreatePVector(Element* element);
		ElementVector* CreatePVectorVolume(Element* element);
		ElementVector* CreatePVectorBase(Element* element);
		void GetB(IssmDouble* B,Element* element,IssmDouble* xyz_list,Gauss* gauss);
		void GetBprime(IssmDouble* B,Element* element,IssmDouble* xyz_list,Gauss* gauss);
		void GetSolutionFromInputs(Vector<IssmDouble>* solution,Element* element);
		void InputUpdateFromSolution(IssmDouble* solution,Element* element);
};
#endif
