/*! \file TriaInput.h 
 *  \brief: header file for TriaInput object
 */

#ifndef _TRIAINPUT_H_
#define _TRIAINPUT_H_

/*Headers:*/
/*{{{*/
#include "./Input.h"
#include "../Elements/TriaRef.h"
class Gauss;
class Gauss;
/*}}}*/

class TriaInput: public Input,public TriaRef{

	public:
		int         enum_type;
		IssmDouble* values;

		/*TriaInput constructors, destructors*/
		TriaInput();
		TriaInput(int enum_type,IssmDouble* values,int element_type_in);
		~TriaInput();

		/*Object virtual functions definitions*/
		void    Echo();
		void    DeepEcho();
		int     Id();
		int     ObjectEnum();
		Object *copy();

		/*TriaInput management:*/
		int    InstanceEnum();
		Input* SpawnTriaInput(int location);
		Input* SpawnSegInput(int index1,int index2);
		Input* PointwiseDivide(Input* inputB);
		Input* PointwiseMin(Input* inputB);
		Input* PointwiseMax(Input* inputB);
		int    GetResultInterpolation(void);
		void   AddTimeValues(IssmDouble* values,int step,IssmDouble time){_error_("not supported yet");};
		void   Configure(Parameters* parameters);

		/*numerics*/
		void GetInputValue(bool* pvalue){_error_("not implemented yet");}
		void GetInputValue(int* pvalue){_error_("not implemented yet");}
		void GetInputValue(IssmDouble* pvalue){_error_("not implemented yet");}
		void GetInputValue(IssmDouble* pvalue,Gauss* gauss);
		void GetInputValue(IssmDouble* pvalue,Gauss* gauss,IssmDouble time){_error_("not implemented yet");};
		void GetInputValue(IssmDouble* pvalue,Gauss* gauss,int index){_error_("not implemented yet");};
		void GetInputDerivativeValue(IssmDouble* derivativevalues, IssmDouble* xyz_list,Gauss* gauss);
		void GetInputAverage(IssmDouble* pvalue);
		void GetInputAllTimeAverages(IssmDouble** pvalues,IssmDouble** ptimes, int* pnumtimes);
		void GetInputUpToCurrentTimeAverages(IssmDouble** pvalues, IssmDouble** ptimes, int* pnumtimes, IssmDouble currenttime);
		void GetVxStrainRate2d(IssmDouble* epsilonvx,IssmDouble* xyz_list, Gauss* gauss);
		void GetVyStrainRate2d(IssmDouble* epsilonvy,IssmDouble* xyz_list, Gauss* gauss);
		void GetVxStrainRate3d(IssmDouble* epsilonvx,IssmDouble* xyz_list, Gauss* gauss){_error_("not implemented yet");};
		void GetVyStrainRate3d(IssmDouble* epsilonvy,IssmDouble* xyz_list, Gauss* gauss){_error_("not implemented yet");};
		void GetVzStrainRate3d(IssmDouble* epsilonvz,IssmDouble* xyz_list, Gauss* gauss){_error_("not implemented yet");};
		void GetVxStrainRate3dHO(IssmDouble* epsilonvx,IssmDouble* xyz_list, Gauss* gauss){_error_("not implemented yet");};
		void GetVyStrainRate3dHO(IssmDouble* epsilonvy,IssmDouble* xyz_list, Gauss* gauss){_error_("not implemented yet");};
		void ChangeEnum(int newenumtype);

		void SquareMin(IssmDouble* psquaremin,Parameters* parameters);
		void ConstrainMin(IssmDouble minimum);
		void Set(IssmDouble setvalue);
		void Scale(IssmDouble scale_factor);
		void AXPY(Input* xinput,IssmDouble scalar);
		void Constrain(IssmDouble cm_min, IssmDouble cm_max);
		IssmDouble InfinityNorm(void);
		IssmDouble Max(void);
		IssmDouble MaxAbs(void);
		IssmDouble Min(void);
		IssmDouble MinAbs(void);
		void Extrude(void){_error_("not supported yet");};
		void VerticallyIntegrate(Input* thickness_input){_error_("not supported yet");};
		void GetVectorFromInputs(Vector<IssmDouble>* vector,int* doflist);

};
#endif  /* _TRIAINPUT_H */
