/*!\file:  TriaRef.h
 * \brief abstract class for handling Tria oriented routines, like nodal functions, 
 * strain rate generation, etc ...
 */ 

#ifndef _TRIAREF_H_
#define _TRIAREF_H_

class Gauss;

class TriaRef{

	public: 
		int* element_type_list; //P1CG, P1DG, MINI, P2...
		int  element_type;

		TriaRef();
		TriaRef(const int nummodels);
		~TriaRef();

		/*Management*/
		void SetElementType(int type,int type_counter);

		/*Numerics*/
		void GetBExtrusion(IssmDouble* B_prime, IssmDouble* xyz_list, Gauss* gauss);
		void GetBFS(IssmDouble* B_prime, IssmDouble* xyz_list, Gauss* gauss);
		void GetBSSA(IssmDouble* B, IssmDouble* xyz_list, Gauss* gauss);
		void GetBSSAFS(IssmDouble* B , IssmDouble* xyz_list, Gauss* gauss);
		void GetBprimeFS(IssmDouble* B_prime, IssmDouble* xyz_list, Gauss* gauss);
		void GetBprimeSSA(IssmDouble* Bprime, IssmDouble* xyz_list, Gauss* gauss);
		void GetBprimeSSAFS(IssmDouble* Bprime, IssmDouble* xyz_list, Gauss* gauss);
		void GetBprimeMasstransport(IssmDouble* Bprime, IssmDouble* xyz_list, Gauss* gauss);
		void GetBMasstransport(IssmDouble* B, IssmDouble* xyz_list, Gauss* gauss);
		void GetBHydro(IssmDouble* B, IssmDouble* xyz_list, Gauss* gauss);
		void GetBSSAFriction(IssmDouble* L, IssmDouble* xyz_list,Gauss* gauss);
		void GetJacobian(IssmDouble* J, IssmDouble* xyz_list,Gauss* gauss);
		void GetSegmentJacobianDeterminant(IssmDouble* Jdet, IssmDouble* xyz_list,Gauss* gauss);
		void GetJacobianDeterminant(IssmDouble* Jdet, IssmDouble* xyz_list,Gauss* gauss);
		void GetJacobianInvert(IssmDouble*  Jinv, IssmDouble* xyz_list,Gauss* gauss);
		void GetLFS(IssmDouble* LFS, Gauss* gauss);
		void GetNodalFunctions(IssmDouble* basis,Gauss* gauss);
		void GetNodalFunctions(IssmDouble* basis,Gauss* gauss,int finiteelement);
		void GetNodalFunctionsVelocity(IssmDouble* basis, Gauss* gauss);
		void GetNodalFunctionsPressure(IssmDouble* basis, Gauss* gauss);
		void GetSegmentNodalFunctions(IssmDouble* basis,Gauss* gauss, int index1,int index2);
		void GetSegmentBFlux(IssmDouble* B,Gauss* gauss, int index1,int index2);
		void GetSegmentBprimeFlux(IssmDouble* Bprime,Gauss* gauss, int index1,int index2);
		void GetNodalFunctionsDerivatives(IssmDouble* dbasis,IssmDouble* xyz_list, Gauss* gauss);
		void GetNodalFunctionsDerivatives(IssmDouble* dbasis,IssmDouble* xyz_list, Gauss* gauss,int finiteelement);
		void GetNodalFunctionsDerivativesVelocity(IssmDouble* dbasis,IssmDouble* xyz_list,Gauss* gauss);
		void GetNodalFunctionsDerivativesPressure(IssmDouble* dbasis,IssmDouble* xyz_list,Gauss* gauss);
		void GetNodalFunctionsDerivativesReference(IssmDouble* dbasis,Gauss* gauss);
		void GetNodalFunctionsDerivativesReference(IssmDouble* dbasis,Gauss* gauss,int finiteelement);
		void GetInputValue(IssmDouble* pp, IssmDouble* plist, Gauss* gauss);
		void GetInputValue(IssmDouble* pp, IssmDouble* plist, Gauss* gauss,int finiteelement);
		void GetInputDerivativeValue(IssmDouble* pp, IssmDouble* plist,IssmDouble* xyz_list, Gauss* gauss);

		void NodeOnEdgeIndices(int* pnumindices,int** pindices,int index,int finiteelement);
		int  NumberofNodes(void);
		int  NumberofNodes(int finiteelement);
		int  NumberofNodesVelocity(void);
		int  NumberofNodesPressure(void);
		int  VelocityInterpolation(void);
		int  PressureInterpolation(void);
};
#endif
