function md=Loadresults(md,fem,u_g);
%LOADRESULTS - load results onto model
%
%   The solution (vel,pressure,...) are on the g-set,
%   use index to get the value on each node
%
%   Usage:
%      md=Loadresults(md,fem,u_g)

if ~isstruct(md.results), md.results=struct(); end
if strcmpi(md.type,'2d')
	if fem.ismacayealpattyn,
		m_dh=fem.m_dh;
		indx=1:6:m_dh.gridset.gsize;
		indy=2:6:m_dh.gridset.gsize;
		indp=4:6:m_dh.gridset.gsize;
	else
		m_dhu=fem.m_dhu;
		indx=1:6:m_dhu.gridset.gsize;
		indy=2:6:m_dhu.gridset.gsize;
		indp=4:6:m_dhu.gridset.gsize;
	end

	md.results.diagnostic.step=1;
	md.results.diagnostic.time=0;
	md.results.diagnostic.vx=u_g(indx)*md.yts;
	md.results.diagnostic.vy=u_g(indy)*md.yts;
	md.results.diagnostic.vel=sqrt(u_g(indx).^2+u_g(indy).^2)*md.yts;
	md.results.diagnostic.pressure=u_g(indp);

else

	m_dv=fem.m_dv;
	indx=1:6:m_dv.gridset.gsize;
	indy=2:6:m_dv.gridset.gsize;
	indz=3:6:m_dv.gridset.gsize;
	indp=4:6:m_dv.gridset.gsize;

	md.results.diagnostic.step=1;
	md.results.diagnostic.time=0;
	md.results.diagnostic.vx=u_g(indx)*md.yts;
	md.results.diagnostic.vy=u_g(indy)*md.yts;
	md.results.diagnostic.vz=u_g(indz)*md.yts;
	md.results.diagnostic.vel=sqrt(u_g(indx).^2+u_g(indy).^2+u_g(indz).^2)*md.yts;
	md.results.diagnostic.pressure=u_g(indp);
end
