/*! \file StressbalanceAnalysis.h 
 *  \brief: header file for generic external result object
 */

#ifndef _StressbalanceAnalysis_
#define _StressbalanceAnalysis_

/*Headers*/
#include "./Analysis.h"

class StressbalanceAnalysis: public Analysis{

	public:
		/*Model processing*/
		int  DofsPerNode(int** doflist,int meshtype,int approximation);
		void UpdateParameters(Parameters* parameters,IoModel* iomodel,int solution_enum,int analysis_enum);
		void UpdateElements(Elements* elements,IoModel* iomodel,int analysis_counter,int analysis_type);
		void CreateNodes(Nodes* nodes,IoModel* iomodel);
		void CreateConstraints(Constraints* constraints,IoModel* iomodel);
		void CreateLoads(Loads* loads, IoModel* iomodel);

		/*Finite element Analysis*/
		ElementMatrix* CreateKMatrix(Element* element);
		ElementVector* CreatePVector(Element* element);
		ElementVector* CreatePVectorFS(Element* element);
		ElementVector* CreatePVectorFSViscous(Element* element);
		ElementVector* CreatePVectorFSShelf(Element* element);
		ElementVector* CreatePVectorFSFront(Element* element);
		ElementVector* CreatePVectorHO(Element* element);
		ElementVector* CreatePVectorHODrivingStress(Element* element);
		ElementVector* CreatePVectorHOFront(Element* element);
		ElementVector* CreatePVectorSSA(Element* element);
		ElementVector* CreatePVectorSSADrivingStress(Element* element);
		ElementVector* CreatePVectorSSAFront(Element* element);
		void GetSolutionFromInputs(Vector<IssmDouble>* solution,Element* element);
		void GetSolutionFromInputsFS(Vector<IssmDouble>* solution,Element* element);
		void GetSolutionFromInputsHoriz(Vector<IssmDouble>* solution,Element* element);
		void InputUpdateFromSolution(IssmDouble* solution,Element* element);
		void InputUpdateFromSolutionFS(IssmDouble* solution,Element* element);
		void InputUpdateFromSolutionHO(IssmDouble* solution,Element* element);
		void InputUpdateFromSolutionHOFS(IssmDouble* solution,Element* element);
		void InputUpdateFromSolutionL1L2(IssmDouble* solution,Element* element);
		void InputUpdateFromSolutionSSA(IssmDouble* solution,Element* element);
		void InputUpdateFromSolutionSSAFS(IssmDouble* solution,Element* element);
		void InputUpdateFromSolutionSSAHO(IssmDouble* solution,Element* element);
};
#endif
