/*!\file Misfit.h
 * \brief: header file for Misfit object
 */

#ifndef _MISFIT_H_
#define _MISFIT_H_

/*Headers:*/
/*{{{*/
#include "./Definition.h"
#include "../datastructures/datastructures.h"
#include "./Elements/Element.h"
#include "./Elements/Elements.h"
#include "./FemModel.h"
/*}}}*/

class Misfit: public Object, public Definition{

	public: 

		char*       name;
		int         model_enum;
		int         observation_enum;
		int         weights_enum;
		char*       timeinterpolation;
		
		/*Misfit constructors, destructors :*/
		/*FUNCTION Misfit() {{{*/
		Misfit(){

			this->name = NULL;
			this->model_enum = UNDEF;
			this->observation_enum = UNDEF;
			this->weights_enum = UNDEF;
			this->timeinterpolation=NULL;

		}
		/*}}}*/
		/*FUNCTION Misfit(char* in_name, int in_model_enum, int in_observation_enum char* in_timeinterpolation, int in_weights_enum) {{{*/
		Misfit(char* in_name, int in_model_enum, int in_observation_enum, char* in_timeinterpolation, int in_weights_enum){

			this->name   = xNew<char>(strlen(in_name)+1);
			xMemCpy<char>(this->name,in_name,strlen(in_name)+1);

			this->timeinterpolation   = xNew<char>(strlen(in_timeinterpolation)+1);
			xMemCpy<char>(this->timeinterpolation,in_timeinterpolation,strlen(in_timeinterpolation)+1);

			this->model_enum=in_model_enum;
			this->observation_enum=in_observation_enum;
			this->weights_enum=in_weights_enum;
		}
		/*}}}*/
		/*FUNCTION ~Misfit() {{{*/
		~Misfit(){
			if(this->name)xDelete(this->name);
			if(this->timeinterpolation)xDelete(this->timeinterpolation);
		}
		/*}}}*/
		/*Object virtual function resolutoin: */
		/*FUNCTION Echo(){{{*/
		void Echo(void){
			_printf_(" Misfit: " << name << "\n");
			_printf_("    model_enum: " << model_enum << " " << EnumToStringx(model_enum) << "\n");
			_printf_("    observation_enum: " << observation_enum << " " << EnumToStringx(observation_enum) << "\n");
			_printf_("    weights_enum: " << weights_enum << " " << EnumToStringx(weights_enum) << "\n");
			_printf_("    timeinterpolation: " << timeinterpolation << "\n");
		}
		/*}}}*/
		/*FUNCTION DeepEcho(){{{*/
		void DeepEcho(void){
			this->Echo();
		}
		/*}}}*/
		/*FUNCTION Id(){{{*/
		int Id(void){
			return -1;
		}
		/*}}}*/
		/*FUNCTION ObjectEnum{{{*/
		int ObjectEnum(void){
			return MisfitEnum;
		}
		/*}}}*/
		/*FUNCTION copy {{{*/
		Object* copy() {
			return new Misfit(this->name,this->model_enum,this->observation_enum,this->timeinterpolation,this->weights_enum);
		}
		/*}}}*/
		/*Definition virtual function resolutoin: */
		/*FUNCTION char* Name() {{{*/
		char* Name(){

			char* name2=xNew<char>(strlen(this->name)+1);
			xMemCpy(name2,this->name,strlen(this->name)+1);

			return name2;
		}
		/*}}}*/
		/*FUNCTION IssmDouble Response(FemModel* femmodel) {{{*/
		 IssmDouble Response(FemModel* femmodel){

			 int i;
			 IssmDouble response=0;
			 IssmDouble all_response=0;

			 for(i=0;i<femmodel->elements->Size();i++){
				 Element* element=(Element*)femmodel->elements->GetObjectByOffset(i);
				 response+=element->Misfit(model_enum,observation_enum,weights_enum);
			 }
			 
			 ISSM_MPI_Allreduce ( (void*)&response,(void*)&all_response,1,ISSM_MPI_DOUBLE,ISSM_MPI_SUM,IssmComm::GetComm());
			 return all_response;
		 }
			/*}}}*/
};

#endif  /* _MISFIT_H_ */
