/*!\file Matpar.h
 * \brief: header file for matpar object
 */

#ifndef _MATPAR_H_
#define _MATPAR_H_

/*Headers:*/
/*{{{*/
#include "./Material.h"
class IoModel;
/*}}}*/

class Matpar: public Material{

	private: 
		int	      mid;
		IssmDouble  rho_ice; 
		IssmDouble  rho_water;
		IssmDouble  rho_freshwater;
		IssmDouble  mu_water;
		IssmDouble  heatcapacity;
		IssmDouble  thermalconductivity;
		IssmDouble  temperateiceconductivity;
		IssmDouble  latentheat;
		IssmDouble  beta;
		IssmDouble  meltingpoint;
		IssmDouble  referencetemperature;
		IssmDouble  mixed_layer_capacity;
		IssmDouble  thermal_exchange_velocity;
		IssmDouble  g;
		IssmDouble  desfac;
		IssmDouble  s0p;

		/*hydrology Shreve: */	 
		IssmDouble  hydro_kn;			 
		IssmDouble  hydro_p;		 
		IssmDouble  hydro_q;		 
		IssmDouble  hydro_CR;			 
		IssmDouble  hydro_n; 

		/*hydrology Dual Porous Continuum: */	 
		IssmDouble  sediment_compressibility;
		IssmDouble  sediment_porosity;	 
		IssmDouble  sediment_thickness;
		IssmDouble  sediment_transmitivity;	 
		IssmDouble  water_compressibility;

		IssmDouble  epl_compressibility;
		IssmDouble  epl_porosity;
		IssmDouble  epl_init_thickness;
		IssmDouble  epl_conductivity;	 

		/*gia: */
		IssmDouble lithosphere_shear_modulus;
		IssmDouble lithosphere_density;
		IssmDouble mantle_shear_modulus;
		IssmDouble mantle_density;

	public:
		Matpar();
		Matpar(int matpar_id, IoModel* iomodel);
		~Matpar();

		/*Object virtual functions definitions:{{{ */
		void    Echo();
		void    DeepEcho();
		int     Id();
		int     ObjectEnum();
		Object *copy();
		/*}}}*/
		/*Update virtual functions resolution: {{{*/
		void   InputUpdateFromVector(IssmDouble* vector, int name, int type);
		void   InputUpdateFromMatrixDakota(IssmDouble* matrix,int nrows,int ncols, int name, int type);
		void   InputUpdateFromVectorDakota(IssmDouble* vector, int name, int type);
		void   InputUpdateFromConstant(IssmDouble constant, int name);
		void   InputUpdateFromConstant(int constant, int name);
		void   InputUpdateFromConstant(bool constant, int name);
		void   InputUpdateFromIoModel(int index, IoModel* iomodel){_error_("not implemented yet");};
		/*}}}*/
		/*Material virtual functions resolution: {{{*/
		void       InputDuplicate(int original_enum,int new_enum);
		void       Configure(Elements* elements);
		void       GetVectorFromInputs(Vector<IssmDouble>* vector,int input_enum){return;}
		void       GetViscosity2d(IssmDouble* pviscosity, IssmDouble* pepsilon){_error_("not supported");};
		void       GetViscosity2dvertical(IssmDouble* pviscosity, IssmDouble* pepsilon){_error_("not supported");};
		void       GetViscosity3d(IssmDouble* pviscosity3d, IssmDouble* pepsilon){_error_("not supported");};
		void       GetViscosity3dFS(IssmDouble* pviscosity3d, IssmDouble* epsilon){_error_("not supported");};
		void       GetViscosityComplement(IssmDouble* pviscosity_complement, IssmDouble* pepsilon){_error_("not supported");};
		void       GetViscosityDComplement(IssmDouble* pviscosity_complement, IssmDouble* pepsilon){_error_("not supported");};
		void       GetViscosityDerivativeEpsSquare(IssmDouble* pmu_prime, IssmDouble* pepsilon){_error_("not supported");};
		void       GetViscosityDerivativeEpsSquareFS(IssmDouble* pmu_prime, IssmDouble* pepsilon){_error_("not supported");};
		void       GetViscosity2dDerivativeEpsSquare(IssmDouble* pmu_prime, IssmDouble* pepsilon){_error_("not supported");};
		IssmDouble GetA(){_error_("not supported");};
		IssmDouble GetAbar(){_error_("not supported");};
		IssmDouble GetB(){_error_("not supported");};
		IssmDouble GetBbar(){_error_("not supported");};
		IssmDouble GetN(){_error_("not supported");};
		IssmDouble GetD(){_error_("not supported");};
		IssmDouble GetDbar(){_error_("not supported");};
		/*}}}*/
		/*Numerics: {{{*/
		IssmDouble GetG();
		IssmDouble GetRhoIce();
		IssmDouble GetRhoWater();
		IssmDouble GetRhoFreshwater();
		IssmDouble GetMuWater();
		IssmDouble GetMixedLayerCapacity();
		IssmDouble GetThermalExchangeVelocity();
		IssmDouble GetHeatCapacity();
		IssmDouble GetThermalConductivity();
		IssmDouble GetTemperateIceConductivity();
		IssmDouble GetLatentHeat();
		IssmDouble GetBeta();
		IssmDouble GetMeltingPoint();
		IssmDouble GetReferenceTemperature();
		IssmDouble GetHydrologyKn();
		IssmDouble GetHydrologyP();
		IssmDouble GetHydrologyQ();
		IssmDouble GetHydrologyCR();
		IssmDouble GetHydrologyN();
		IssmDouble GetSedimentStoring();
		IssmDouble GetEplSpecificStoring();
		IssmDouble GetSedimentTransmitivity();
		IssmDouble GetSedimentThickness();
		IssmDouble GetEplConductivity();
		IssmDouble GetEplInitialThickness();
		IssmDouble TMeltingPoint(IssmDouble pressure);
		IssmDouble PureIceEnthalpy(IssmDouble pressure);
		IssmDouble GetEnthalpyDiffusionParameter(IssmDouble enthalpy,IssmDouble pressure);
		IssmDouble GetEnthalpyDiffusionParameterVolume(IssmDouble enthalpy[6], IssmDouble pressure[6]);
		IssmDouble GetLithosphereShearModulus();
		IssmDouble GetLithosphereDensity();
		IssmDouble GetMantleShearModulus();
		IssmDouble GetMantleDensity();
		void       EnthalpyToThermal(IssmDouble* ptemperature,IssmDouble* pwaterfraction,IssmDouble enthalpy,IssmDouble pressure);
		void       ThermalToEnthalpy(IssmDouble* penthalpy,IssmDouble temperature,IssmDouble waterfraction,IssmDouble pressure);
		IssmDouble GetDesFac();
		IssmDouble GetS0p(); 
		IssmDouble GetMaterialParameter(int in_enum); 
		bool       IsInput(int name);
		/*}}}*/

};

#endif  /* _MATPAR_H_ */
