from fielddisplay import fielddisplay
from EnumDefinitions import *
from checkfield import *
from WriteData import *

class surfaceforcings(object):
	"""
	SURFACEFORCING Class definition

	   Usage:
	      surfaceforcings=surfaceforcings();
	"""

	def __init__(self): # {{{
		self.precipitation             = float('NaN')
		self.mass_balance              = float('NaN')
		self.ispdd                     = 0
		self.issmbgradients            = 0
		self.isdelta18o                = 0
		self.href                      = float('NaN')
		self.smbref                    = float('NaN')
		self.b_pos                     = float('NaN')
		self.b_neg                     = float('NaN')
		self.monthlytemperatures       = float('NaN')
		self.delta18o                  = float('NaN')
		self.delta18o_surface          = float('NaN')
		self.temperatures_presentday   = float('NaN')
		self.temperatures_lgm          = float('NaN')
		self.precipitations_presentday = float('NaN')
		self.desfac                    = 0.
		self.s0p                       = 0.

		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(self): # {{{
		string="   surface forcings parameters:"

		string="%s\n%s"%(string,fielddisplay(self,'precipitation','surface precipitation [m/yr water eq]'))
		string="%s\n%s"%(string,fielddisplay(self,'mass_balance','surface mass balance [m/yr ice eq]'))
		string="%s\n%s"%(string,fielddisplay(self,'ispdd','is pdd activated (0 or 1, default is 0)'))
		string="%s\n%s"%(string,fielddisplay(self,'desfac','desertification elevation factor (between 0 and 1, default is 0.5) [m]'))
		string="%s\n%s"%(string,fielddisplay(self,'isdelta18o','is temperature and precipitation delta18o parametrisation activated (0 or 1, default is 0)'))
		string="%s\n%s"%(string,fielddisplay(self,'s0p','should be set to elevation from precip source (between 0 and a few 1000s m, default is 0) [m]'))
		string="%s\n%s"%(string,fielddisplay(self,'monthlytemperatures','monthly surface temperatures [K], required if pdd is activated and delta18o not activated'))
		string="%s\n%s"%(string,fielddisplay(self,'precipitation','surface precipitation [m/yr water eq]'))
		string="%s\n%s"%(string,fielddisplay(self,'temperatures_presentday','monthly present day surface temperatures [K], required if pdd is activated and delta18o activated'))
		string="%s\n%s"%(string,fielddisplay(self,'temperatures_lgm','monthly LGM surface temperatures [K], required if pdd is activated and delta18o activated'))
		string="%s\n%s"%(string,fielddisplay(self,'precipitations_presentday','monthly surface precipitation [m/yr water eq], required if pdd is activated and delta18o activated'))
		string="%s\n%s"%(string,fielddisplay(self,'delta18o','delta18o, required if pdd is activated and delta18o activated'))
		string="%s\n%s"%(string,fielddisplay(self,'delta18o_surface','surface elevation of the delta18o site, required if pdd is activated and delta18o activated'))
		string="%s\n%s"%(string,fielddisplay(self,'issmbgradients','is smb gradients method activated (0 or 1, default is 0)'))
		string="%s\n%s"%(string,fielddisplay(self,'href',' reference elevation from which deviation is used to calculate SMB adjustment in smb gradients method'))
		string="%s\n%s"%(string,fielddisplay(self,'smbref',' reference smb from which deviation is calculated in smb gradients method'))
		string="%s\n%s"%(string,fielddisplay(self,'b_pos',' slope of hs - smb regression line for accumulation regime required if smb gradients is activated'))
		string="%s\n%s"%(string,fielddisplay(self,'b_neg',' slope of hs - smb regression line for ablation regime required if smb gradients is activated'))

		return string
		#}}}
	def setdefaultparameters(self): # {{{
		  
		#pdd method not used in default mode
		self.ispdd=0
		self.issmbgradients=0
		self.isdelta18o=0
		self.desfac=0.5
		self.s0p=0.

		return self
	#}}}
	def checkconsistency(self,md,solution,analyses):    # {{{

		if MasstransportAnalysisEnum() in analyses:
			md = checkfield(md,'fieldname','surfaceforcings.ispdd','numel',[1],'values',[0,1])
			md = checkfield(md,'fieldname','surfaceforcings.issmbgradients','numel',[1],'values',[0,1])
			if   self.ispdd:
				md = checkfield(md,'fieldname','surfaceforcings.desfac','<=',1,'numel',[1]);
				md = checkfield(md,'fieldname','surfaceforcings.s0p','>=',0,'numel',[1]);
				if not self.isdelta18o:
					md = checkfield(md,'fieldname','surfaceforcings.monthlytemperatures','forcing',1,'NaN',1)
					md = checkfield(md,'fieldname','surfaceforcings.precipitation','forcing',1,'NaN',1)
				else:
					md = checkfield(md,'fieldname','surfaceforcings.delta18o','NaN',1)
					md = checkfield(md,'fieldname','surfaceforcings.delta18o_surface','NaN',1)
					md = checkfield(md,'fieldname','surfaceforcings.temperatures_presentday','size',[md.mesh.numberofvertices+1,12],'NaN',1)
					md = checkfield(md,'fieldname','surfaceforcings.temperatures_lgm','size',[md.mesh.numberofvertices+1,12],'NaN',1)
					md = checkfield(md,'fieldname','surfaceforcings.precipitations_presentday','size',[md.mesh.numberofvertices+1,12],'NaN',1)
			elif self.issmbgradients:
				md = checkfield(md,'fieldname','surfaceforcings.href','forcing',1,'NaN',1)
				md = checkfield(md,'fieldname','surfaceforcings.smbref','forcing',1,'NaN',1)
				md = checkfield(md,'fieldname','surfaceforcings.b_pos','forcing',1,'NaN',1)
				md = checkfield(md,'fieldname','surfaceforcings.b_neg','forcing',1,'NaN',1)
			else:
				md = checkfield(md,'fieldname','surfaceforcings.mass_balance','forcing',1,'NaN',1)

		if BalancethicknessAnalysisEnum() in analyses:
			md = checkfield(md,'fieldname','surfaceforcings.mass_balance','size',[md.mesh.numberofvertices],'NaN',1)

		return md
	# }}}
	def marshall(self,md,fid):    # {{{

		yts=365.0*24.0*3600.0

		WriteData(fid,'object',self,'fieldname','precipitation','format','DoubleMat','mattype',1,'scale',1./yts,'forcinglength',md.mesh.numberofvertices+1)
		WriteData(fid,'object',self,'fieldname','mass_balance','format','DoubleMat','mattype',1,'scale',1./yts,'forcinglength',md.mesh.numberofvertices+1)
		WriteData(fid,'object',self,'fieldname','ispdd','format','Boolean')
		WriteData(fid,'object',self,'fieldname','isdelta18o','format','Boolean')

		if self.ispdd:
			WriteData(fid,'object',self,'fieldname','desfac','format','Double');
			WriteData(fid,'object',self,'fieldname','s0p','format','Double');
			if self.isdelta18o:
				WriteData(fid,'object',self,'fieldname','temperatures_presentday','format','DoubleMat','mattype',1)
				WriteData(fid,'object',self,'fieldname','temperatures_lgm','format','DoubleMat','mattype',1)
				WriteData(fid,'object',self,'fieldname','precipitations_presentday','format','DoubleMat','mattype',1)
				WriteData(fid,'object',self,'fieldname','delta18o_surface','format','DoubleMat','mattype',1)
				WriteData(fid,'object',self,'fieldname','delta18o','format','DoubleMat','mattype',1)
			else:
				WriteData(fid,'object',self,'fieldname','monthlytemperatures','format','DoubleMat','mattype',1,'forcinglength',md.mesh.numberofvertices+1)

		WriteData(fid,'object',self,'fieldname','issmbgradients','format','Boolean')

		if self.issmbgradients:
			WriteData(fid,'object',self,'fieldname','href','format','DoubleMat','mattype',1,'forcinglength',md.mesh.numberofvertices+1)
			WriteData(fid,'object',self,'fieldname','smbref','format','DoubleMat','mattype',1,'scale',1./yts,'forcinglength',md.mesh.numberofvertices+1)
			WriteData(fid,'object',self,'fieldname','b_pos','format','DoubleMat','mattype',1,'scale',1./yts,'forcinglength',md.mesh.numberofvertices+1)
			WriteData(fid,'object',self,'fieldname','b_neg','format','DoubleMat','mattype',1,'scale',1./yts,'forcinglength',md.mesh.numberofvertices+1)
	# }}}
