%MISCELLANEOUS class definition
%
%   Usage:
%      miscellaneous=miscellaneous();

classdef miscellaneous
	properties (SetAccess=public) 
		notes = '';
		name  = '';
		dummy = struct();
	end
	methods
		function obj = miscellaneous(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{

			md = checkfield(md,'fieldname','miscellaneous.name','empty',1);

		end % }}}
		function obj = setdefaultparameters(obj) % {{{

		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   miscellaneous parameters:'));

			fielddisplay(obj,'notes','notes in a cell of strings');
			fielddisplay(obj,'name','model name');
			fielddisplay(obj,'dummy','empty field to store some data');

		end % }}}
		function marshall(obj,md,fid) % {{{
			WriteData(fid,'object',obj,'fieldname','name','format','String');
		end % }}}
	end
end
